/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.eclipse.cosmos.me.sdd.schema.DeploymentDescriptorType;
import org.eclipse.cosmos.me.sdd.schema.PackageDescriptorType;
import org.eclipse.cosmos.me.sdd.tooling.btg.BTGProperty;
import org.eclipse.cosmos.me.sdd.tooling.btg.IBTGDataAggregator;
import org.eclipse.cosmos.me.sdd.tooling.btg.SDDFragment;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.DeploymentDescriptorCompare;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregator
implements IBTGDataAggregator {
    Logger logger = Logger.getLogger("org.eclipse.cosmos.me.deployment.tooling.sdd.btg");
    Logger consoleLogger = Logger.getLogger("org.eclipse.cosmos.me.deployment.tooling.sdd.btg.stdout");
    private static DeploymentDescriptorType dd1;
    private static DeploymentDescriptorType dd2;
    private static PackageDescriptorType pd1;
    private static PackageDescriptorType pd2;

    public Collection<BTGProperty> getSupportedProperties() {
        ArrayList<BTGProperty> properties = new ArrayList<BTGProperty>();
        return properties;
    }

    public Collection<Object> aggregateSDDData(Collection<SDDFragment> fragments, Properties properties, boolean allowIncompleteSDDs) {
        try {
            this.consoleLogger.info("welcome to the aggregator");
            if (fragments.size() != 0) {
                Iterator<SDDFragment> sddIter = fragments.iterator();
                DeploymentDescriptorType resultingDD = (DeploymentDescriptorType)sddIter.next().getFragment().getValue();
                while (sddIter.hasNext()) {
                    dd1 = resultingDD;
                    dd2 = (DeploymentDescriptorType)sddIter.next().getFragment().getValue();
                    resultingDD = DeploymentDescriptorCompare.merge(dd1, dd2);
                }
                ArrayList<Object> returnArray = new ArrayList<Object>();
                returnArray.add(resultingDD);
                Aggregator.writeSDD(resultingDD);
                return returnArray;
            }
            this.consoleLogger.info("No fragments passed to aggregator");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeSDD(DeploymentDescriptorType doc) {
        String outputLocation = "C:\\";
        try {
            JAXBContext uninstallJc = JAXBContext.newInstance((String)"org.eclipse.cosmos.me.sdd.schema");
            Marshaller m = uninstallJc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
            m.marshal((Object)doc, (OutputStream)new FileOutputStream(String.valueOf(outputLocation) + "outputSDD.xml"));
        }
        catch (JAXBException je) {
            je.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static DeploymentDescriptorType getDd1() {
        return dd1;
    }

    public static DeploymentDescriptorType getDd2() {
        return dd2;
    }

    public static boolean setDd1(DeploymentDescriptorType dd) {
        try {
            dd1 = dd;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean setDd2(DeploymentDescriptorType dd) {
        try {
            dd2 = dd;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Collection<DeploymentDescriptorType> getAllDeploymentDescriptors() {
        ArrayList<DeploymentDescriptorType> deploymentDescriptors = new ArrayList<DeploymentDescriptorType>();
        deploymentDescriptors.add(Aggregator.getDd1());
        deploymentDescriptors.add(Aggregator.getDd2());
        return deploymentDescriptors;
    }

    public static PackageDescriptorType getPd1() {
        return pd1;
    }

    public static PackageDescriptorType getPd2() {
        return pd2;
    }

    public static boolean setPd1(PackageDescriptorType pd) {
        try {
            pd1 = pd;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean setPd2(PackageDescriptorType pd) {
        try {
            pd2 = pd;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Collection<PackageDescriptorType> getAllPackageDescriptors() {
        ArrayList<PackageDescriptorType> packageDescriptors = new ArrayList<PackageDescriptorType>();
        packageDescriptors.add(Aggregator.getPd1());
        packageDescriptors.add(Aggregator.getPd2());
        return packageDescriptors;
    }
}

