/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.common.validation.exception;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import org.eclipse.cosmos.me.sdd.common.validation.XMLValidationError;

/**
 * 
 * @author Eric S. Rose (esrose@us.ibm.com)
 *
 */
public class XMLValidationException extends Exception {
	private static final long serialVersionUID = -4741537800562328893L;
	// List of XMLValidationErrors
	private Collection<XMLValidationError> xmlValidationErrors;
	
	
	public XMLValidationException(Collection<XMLValidationError> errorList) {
		xmlValidationErrors = errorList;
	}
	
	public XMLValidationException(XMLValidationError error) {
		xmlValidationErrors = new Vector<XMLValidationError>();
		
		xmlValidationErrors.add(error);
	}
	
	public Iterator<XMLValidationError> getValidationErrorIterator() {
		return (xmlValidationErrors.iterator());
	}	
}
