package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.schema.RequiredBaseConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;

public class RequiredBaseConstraintCompare
{

	public static Collection<? extends RequiredBaseConstraintType> merge(List<RequiredBaseConstraintType> bc, List<RequiredBaseConstraintType> bc2)
	{
		Vector <RequiredBaseConstraintType> toRemove = new Vector <RequiredBaseConstraintType> ();
		Iterator <RequiredBaseConstraintType> iter1 = bc.iterator();		
		//iterate through the items
		while (iter1.hasNext())
		{
			RequiredBaseConstraintType o1 = (RequiredBaseConstraintType) iter1.next();
			Iterator <RequiredBaseConstraintType> iter2 = bc2.iterator();
			while (iter2.hasNext())
			{
				RequiredBaseConstraintType o2 = (RequiredBaseConstraintType) iter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (toRemove.contains(o2)==false)
				{
					if (equals(o1, o2))
					{  
						toRemove.add(o2);
						o1 = merge(o1,o2);
					}
				}
					
			}
		}
		
		bc2.removeAll(toRemove);
		//remove all of the matches that were found
		
		Vector <RequiredBaseConstraintType> finals = new Vector <RequiredBaseConstraintType> ();
		//create and return a new collection with all of the remaining items
		finals.addAll(bc);
		finals.addAll(bc2);		
		
		return finals;
	}
	
//	<RequiredBaseConstraintType> 	 	 	 	
//	id 	xsd:ID 	Throw Away
//	resourceRef 	xsd:IDREF 	Yes
//	testValue 	xsd:boolean 	Yes
//	any 	namespace="##other" 	 ?
//DisplayElementGroup 		DisplayElementGroup 	Merge
//Name 		<VariableExpressionType> 	Merge
//VersionConstraint 		<VersionConstraintType> 	Yes

	protected static RequiredBaseConstraintType merge(RequiredBaseConstraintType o1,	RequiredBaseConstraintType o2)
	{
		ObjectFactory objectFactory = new ObjectFactory();
		RequiredBaseConstraintType rc = objectFactory.createRequiredBaseConstraintType();
		rc.setDescription(DisplayTextCompare.merge(o1.getDescription(), o2.getDescription()));
		rc.setDisplayName(DisplayTextCompare.merge(o1.getDisplayName(), o2.getDisplayName()));
		rc.setId(o1.getId());
		rc.setName(StringCompare.merge(o1.getName(), o2.getName()));
		rc.setShortDescription(DisplayTextCompare.merge(o1.getShortDescription(), o2.getShortDescription()));
		rc.setTestValue(o1.isTestValue());
		rc.setResourceRef(o1.getResourceRef());
		rc.setVersionConstraint(VersionConstraintCompare.merge(o1.getVersionConstraint(),o2.getVersionConstraint()));
		return rc;
	}

	protected static boolean equals(RequiredBaseConstraintType rc, RequiredBaseConstraintType rc2)
	{
		if (!ResourceCompare.equals((ResourceType)rc.getResourceRef(),(ResourceType)rc2.getResourceRef()))
			return false;
		if (rc.isTestValue()!=rc2.isTestValue())
			return false;
		return true;
	}
}
