package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.cosmos.me.sdd.schema.ConditionalPropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;

public class ConditionalPropertyConstraintCompare
{
//	<ConditionalPropertyConstraintType> 	 	 	 	
//	DescriptionGroup 		DescriptionGroup 	Merge
//	PropertyName 		xsd:QName 	Yes
//	Value 		xsd:string 	Yes
//	ListOfValues 		<PropertyValueListType> 	Yes 
	public static Vector<ConditionalPropertyConstraintType> merge(List<ConditionalPropertyConstraintType> pcs,	List<ConditionalPropertyConstraintType> pcs2)
	{
		Vector <ConditionalPropertyConstraintType> toRemove = new Vector <ConditionalPropertyConstraintType> ();
		Iterator <ConditionalPropertyConstraintType> iter1 = pcs.iterator();		
		//iterate through the items
		while (iter1.hasNext())
		{
			ConditionalPropertyConstraintType o1 = (ConditionalPropertyConstraintType) iter1.next();
			Iterator <ConditionalPropertyConstraintType> iter2 = pcs2.iterator();
			while (iter2.hasNext())
			{
				ConditionalPropertyConstraintType o2 = (ConditionalPropertyConstraintType) iter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (toRemove.contains(o2)==false)
				{
					if (equals(o1, o2))
					{  
						//merge hosted resources, types and description groups
						toRemove.add(o2);
						o1 = merge(o1,o2);
					}
				}
					
			}
		}
		
		pcs2.removeAll(toRemove);
		//remove all of the matches that were found
		
		Vector <ConditionalPropertyConstraintType> finals = new Vector <ConditionalPropertyConstraintType> ();
		//create and return a new collection with all of the remaining items
		finals.addAll(pcs);
		finals.addAll(pcs2);		
		
		return finals;
	}

	protected static ConditionalPropertyConstraintType merge(ConditionalPropertyConstraintType o1,	ConditionalPropertyConstraintType o2)
	{
		ObjectFactory objectFactory = new ObjectFactory();
		ConditionalPropertyConstraintType pc = objectFactory.createConditionalPropertyConstraintType();
		pc.setDescription(DisplayTextCompare.merge(o1.getDescription(), o2.getDescription()));
		pc.setShortDescription(DisplayTextCompare.merge(o1.getShortDescription(), o2.getShortDescription()));
		
		pc.setListOfValues(o1.getListOfValues());
		pc.setPropertyName(o1.getPropertyName());
		pc.setValue(o1.getValue());
		
		return pc;
	}

	protected static boolean equals(ConditionalPropertyConstraintType pc, ConditionalPropertyConstraintType pc2)
	{
		if (!PropertyValueListCompare.equals(pc.getListOfValues(),pc2.getListOfValues()))
			return false;
		if (!StringCompare.equals(pc.getValue(),pc2.getValue()))
			return false;
		if (!StringCompare.equals(pc.getPropertyName(),pc2.getPropertyName()))
			return false;
		return true;
	}

}
