package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.schema.StringParameterType;

public class StringParameterCompare
{
	
	protected static Vector<StringParameterType> merge(List<StringParameterType> params, List<StringParameterType> params2)
	{
		Vector <StringParameterType> toRemove = new Vector <StringParameterType> ();
		Iterator <StringParameterType> iter1 = params.iterator();		
		//iterate through the items
		while (iter1.hasNext())
		{
			StringParameterType o1 = (StringParameterType) iter1.next();
			Iterator <StringParameterType> iter2 = params2.iterator();
			while (iter2.hasNext())
			{
				StringParameterType o2 = (StringParameterType) iter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (toRemove.contains(o2)==false)
				{
					if (equals(o1, o2))
					{  
						//merge hosted resources, types and description groups
						toRemove.add(o2);
						o1 = merge(o1,o2);
					}
				}
					
			}
		}
		
		params2.removeAll(toRemove);
		//remove all of the matches that were found
		
		Vector <StringParameterType> finals = new Vector <StringParameterType> ();
		//create and return a new collection with all of the remaining items
		finals.addAll(params);
		finals.addAll(params2);		
		
		return finals;
	}

	private static boolean equals(StringParameterType o1, StringParameterType o2)
	{
		if (!StringCompare.equals(o1.getDefaultValue(),o2.getDefaultValue()))
			return false;
		if (o1.isSensitive()!=o2.isSensitive())
			return false;
		if (o1.isRequired()!=o2.isRequired())
			return false;
		if (OperationCompare.equals(o1.getOperation(),o2.getOperation()))
			return false;
		return true;
	}
	protected static StringParameterType merge(StringParameterType string1, StringParameterType string2)
	{
		ObjectFactory objectFactory = new ObjectFactory();
		StringParameterType merged = objectFactory.createStringParameterType();
		
		BigInteger minLength = string1.getMinLength();
		BigInteger maxLength = string1.getMaxLength();
		
		merged.getValidValue().addAll(string1.getValidValue());
		
		if (string2.getMaxLength()!=null)
		{
			if (maxLength==null)
				maxLength=string2.getMaxLength();
			else if (string2.getMaxLength().compareTo(maxLength)<0)
				maxLength = string2.getMaxLength();
		}
		if (string2.getMinLength()!=null)
		{
			if (minLength==null)
				minLength=string2.getMinLength();
			else if (string2.getMinLength().compareTo(minLength)>0)
				minLength = string2.getMinLength();
		}
		
		Iterator <String> sIter = string2.getValidValue().iterator();
		while (sIter.hasNext())
		{
			String val = sIter.next();
			if (!merged.getValidValue().contains(val))
				merged.getValidValue().add(val);
		}
		
		merged.setMaxLength(maxLength);
		merged.setMinLength(minLength);
		merged.setDisplayName(DisplayTextCompare.merge(string1.getDisplayName(), string2.getDisplayName()));
		merged.setDescription(DisplayTextCompare.merge(string1.getDescription(), string2.getDescription()));
		
		merged.setCase(StringCaseCompare.merge(string1.getCase(),string2.getCase()));
		
		return merged;
		
	}	

}