/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts;

import java.net.URI;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Represents the <recordType> element.
 * 
 * 
 * @author David Whiteman
 */
public interface IRecordType extends IConstraint, IXMLWritable {
	/**
	 * Answer the namespace for the record type constraint
	 * 
	 * @return
	 */
	public URI getNamespace();

	/**
	 * Set the namespace for the record type constraint
	 * 
	 * @param namespace
	 */
	public void setNamespace(URI namespace);

	/**
	 * Answer the local name of the record type
	 * 
	 * @return
	 */
	public String getLocalName();

	/**
	 * Set the local name for the record type
	 * 
	 * @param localName
	 */
	public void setLocalName(String localName);
}
