/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Represents the <declined> element as part of a register response or
 * a deregister response.
 * 
 * 
 * @author David Whiteman
 */
public interface IDeclined extends IXMLWritable {
	/**
	 * Answer an array of Strings representing the reasons for
	 * a register or deregister request being declined
	 * 
	 * @return
	 */
	public String[] getReasons();

	/**
	 * Add a reason to the list of reasons why this request was
	 * declined.
	 * 
	 * @param reason
	 */
	public void addReason(String reason);

}
