/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: IFormatter.java,v 1.1 2008/01/04 21:44:31 sleeloy Exp $
 **********************************************************************/
package org.eclipse.cosmos.provisional.dr.drs.service.handler.cmdbf;

import java.io.PrintWriter;

import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.w3c.dom.Element;

/**
 * Provides data feeds  
 */
public interface IFormatter extends IOutputter{
	
	/**
	 * Writes content to a PrintWriter.  An input map is passed to this method 
	 * that the render method will use to generate the data feed
	 * @param output a PrintWriter that method will write to
	 * @param input an input map that contains name value pairs
	 * @param graphResponse the graph response from a submitted cmdbfquery
	 * @throws Exception 
	 */
	public abstract void render(PrintWriter output, IParameters input, Element graphResponse)	throws Exception;
	
}
