/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.Report");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.utility.common");
dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.widget.ReportMenu",
	// superclass	
	null,
	{
		// summary: This class provides a report menu option
		// description: This class provides a report menu option based on information received by making a XMLHTTPRequest.  The 
	    //              information is expected to be a JSON datastructure that conforms to the following syntax:
	    //                      [{"caption":"Statistical Report","value":"1"}]
	    //              The json defines an array of objects that has a caption and value property.  The caption defines the
	    //              the string that will be used as the label of the menu option.  The value is used as a unique id and sent to the reporting
	    //              system to determine which report should be generated.
		//query: org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery
		//  a query object that provides the url used to get the array of menu options 	     
	    query: null,
	    //publish:String
	    // Defines the topic that is will be published when the user selects the menu option
	    publish: null,
		constructor: function(params){
	   		//summary: constructor that mix in the properties passed in the params parameter
			dojo.mixin(this,params);
		},
		createContextMenu: function(menu, store, className){
			//summary: This method will construct the menu options
			// menu: the menu widget that the menu option will be added to
			// store: the store.item will contain the node that was selected to bring up the menu
			// className: the nodeClass of the selected item
			this.populateMenu(menu, store, className);
		},
		populateMenu:function(menu, store, className){
			//summary: This method will construct the menu options
			// menu: the menu widget that the menu option will be added to
			// store: the store.item will contain the node that was selected to bring up the menu
			// className: the nodeClass of the selected item
			var self = this;
	    	var queryObject = this.UIContext.createObject(this.query);
			this.UIContext.submitQuery({queryObject:queryObject, item:store.item, onItem:function(items){
				for (i=0;i < items.length;i++){
					menu.addChild(new dijit.MenuItem({item:store.item,publish:self.publish, value:items[i], onClick:function(){
						if (typeof(this.publish) != 'undefined'){
							var contextMap = this.item;
							var publishList = this.publish;
							var newValues = this.value;
							//check if we should refresh the reponse
							if (this.item.getResponse){
								store.tree.refreshQuery(this.item, store, function(response){
									//clone item since we don't want to modify the original item
									dojo.mixin(contextMap, newValues);
									for (y=0;y < publishList.length;y++){
										dojo.publish(publishList[y], [{contextMap:contextMap}]);
						 			}
								});
							}
							else{
								//clone item since we don't want to modify the original item
								dojo.mixin(contextMap, newValues);
								for (y=0;y < publishList.length;y++){
									dojo.publish(publishList[y], [{contextMap:contextMap}]);
					 			}
							}
						}	    
						
					},
					label:items[i].caption,
					iconClass: (self.icon == null ? "" : self.icon)					
					}));				
				}
			}, queryProp:"query"});
			
		}
	}
);

dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.widget.ReportQuery",
	// superclass	
   [org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery],
	{
		// summary: This is a query class used to send a XMLHTTPRequset to get a list of menu options
		// description: This query class adds the following parameters to the request.  
	    //                 func=list
	    //                 value= classification
	    //               The func parameter is set to a value of 'list'.  This will tell the service 
	    //               to provide a list of report menu items associated with a particular classification 
	    //               defined by the value parameter.
		bindInput: function(/*Object*/data, /*function*/callbackMethod){		
	    //summary: binds the XMLHTTPRequest to parameters defined in the data object
	    //data: contains a classification property that defines the classification that is used in the request
	    //callbackMethod: a function that is used to bind the data with the request
	   		var postData = "func=list";
	   		if (data.classification)
	   			postData += "&__ptype="+data.classification;
				callbackMethod(postData);
		}
	}
); 

dojo.declare(
		   "org.eclipse.cosmos.provisional.dr.ps.components.widget.ReportContentQuery",
			// superclass	
		   [org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery],
			{
				 handleAs:"text",
				// summary: This is a basic query class used to send a XMLHTTPRequset to get the contents of a 
			    //          generated report from a reporting system
				URLEncode: function(/*String*/sStr) {
			    // summary: This function provides HTMLEntity escaping on the String passed in.
			    return escape(sStr)
		  			.replace(/\+/g, '%2B')
		     			.replace(/\"/g,'%22')
		        			.replace(/\'/g, '%27'); 
				}
			}
		); 

		     			
dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.widget.CBEReportContentQuery",
	// superclass	
   [org.eclipse.cosmos.provisional.dr.ps.components.widget.ReportContentQuery],
	{
		// summary: This is a query class used to send a XMLHTTPRequset to get the contents of a 
	    //          CBE generated report from a reporting system
		bindInput: function(data, callbackMethod){
	    //summary: binds the XMLHTTPRequest to parameters defined in the data object
	    //data: contains the reportId, epr and logfile properties needed by the CBE report template to generate the report
	    //callbackMethod: a function that is used to bind the data with the request
			if ((typeof(data)!= 'undefined') && (typeof(data.value) != 'undefined') && (typeof(data.epr)!= 'undefined')){
	    		var reportId = this.URLEncode(data.value);	
				var logfile = this.URLEncode(data.logfile);
				var epr = escape(data.epr);
				callbackMethod("func=url&reportid="+reportId+"&__rEPR="+epr+"&__rLogFile="+logfile);
				return true;
			}
			else{
				return false;
			}
		}
	}
);

dojo.declare(
		   "org.eclipse.cosmos.provisional.dr.ps.components.widget.CMDBfReportInputs",
			// superclass	
		   null,
			{
			   inputs:[],
				constructor: function(params){
			   		//summary: constructor that mix in the properties passed in the params parameter
					dojo.mixin(this,params);
		   		},
				getInputs: function(data){
			    //summary: binds the XMLHTTPRequest to parameters defined in the data object
			    //data: contains the reportId, graphresponse properties needed by the Graph Response report template to generate the report
			    //callbackMethod: a function that is used to bind the data with the request
					if ((typeof(data)!= 'undefined')){
						if (data.queryResponse){
					   		this.inputs["XML_DATASOURCE"] = data.queryResponse;
						}
					}
					return this.inputs;
				}
			}
		); 


dojo.declare(
		   "org.eclipse.cosmos.provisional.dr.ps.components.widget.StatReportContentQuery",
			// superclass	
		   [org.eclipse.cosmos.provisional.dr.ps.components.widget.ReportContentQuery],
			{
				// summary: This is a query class used to send a XMLHTTPRequset to get the contents of a 
			    //          Statistical generated report from a reporting system
				bindInput: function(data, callbackMethod){
			    //summary: binds the XMLHTTPRequest to parameters defined in the data object
			    //data: contains the reportId, epr, datasoruce, keyset properties needed by the Statistical report template to generate the report
			    //callbackMethod: a function that is used to bind the data with the request
					if ((typeof(data)!= 'undefined') && (typeof(data.value) != 'undefined') && (typeof(data.epr)!= 'undefined')){
			    		var reportId = this.URLEncode(data.value);	
						var datasource = this.URLEncode(data.datasource);
						var keyset = this.URLEncode(data.keyset);
						var epr = escape(data.epr);
						callbackMethod("func=url&reportid="+reportId+"&__rEPR="+epr+"&__rDataSource="+datasource+"&__rKeySet="+keyset);
						return true;
					}
					else{
						return false;
					}
				}
			}
		); 