/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.me.internal.dmtoolkit.j2ee.delegates;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.dr.internal.web.ui.WebViewerActivator;
import org.eclipse.cosmos.me.internal.dmtoolkit.j2ee.DMJ2EEPlugin;
import org.eclipse.cosmos.me.internal.dmtoolkit.j2ee.util.J2EEUtilities;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;

/**
 * Opens a web viewer UI on the EPR of the running query service, in response to Run on Server
 * 
 * @author David Whiteman
 */
public class ToolkitLaunchableAdapterDelegate extends
		LaunchableAdapterDelegate implements IServerListener {

	private IServer server;
	private IModuleArtifact moduleArtifact;

	public ToolkitLaunchableAdapterDelegate() {
		super();
	}

	@Override
	public Object getLaunchable(IServer server, IModuleArtifact moduleArtifact)
			throws CoreException {
		initServer(server);
		this.setModuleArtifact(moduleArtifact);
		return null;
	}

	private void initServer(IServer server) {
		if (getServer() == null) {
			setServer(server);
			server.addServerListener(this);
		}
	}

	private void buildEprAndLaunchViewer() throws CoreException {
		// For EPR, need the following:
		// http://localhost:[portnum]/[contextroot]/services/[servicename]
		System.out.println("xxxxxxxxxxxxxx  GOT HERE xxxxxxxxxxxxxxxxxxxx");
//		if (server.getServerState() != IServer.STATE_STARTED) {
//			// should not display as we're not ready yet, get out silently
//			return;
//		}
		IURLProvider urlProvider = (IURLProvider) getServer().getAdapter(IURLProvider.class);
		IModule module = getModuleArtifact().getModule();
		URL url = urlProvider.getModuleRootURL(module);
		String serviceName = locateServiceName(module);
		if (serviceName == null) {
			throw new CoreException(DMJ2EEPlugin.createErrorStatus("Could not locate MDR query service in project"));
		}
		String epr = url + "services/" + serviceName;
		System.out.println("EPR = "+epr);
		showInWebViewer(serviceName, epr);
	}

	private void showInWebViewer(String serviceName, String epr) throws CoreException {
		WebViewerActivator.getDefault().launchCOSMOSUI(serviceName, epr);	
//		HashMap<String, String> map = new HashMap<String,String>();
//		map.put("name", serviceName);
//		map.put("queryservice", epr);
//		WebViewer.display(map);
	}

	// Locate the service name by inspecting the query service WSDL found in the
	// project associated with the module
	private String locateServiceName(IModule module)
			throws CoreException {
		// use module to get project.  from there we should be able to find the WSDL and
		// get the service name from <wsdl:service name="ExampleMdrQueryService">
		// /Bob/WebContent/WEB-INF/services/Bob/META-INF/QueryService.wsdl
		IProject project = module.getProject();
		IFolder servicesFolder = J2EEUtilities.getWebInfServicesDir(project);
		IFolder metaInfFolder = ((IFolder) servicesFolder.members()[0]).getFolder(J2EEUtilities.META_INF_FOLDER_NAME);
		IFile file = metaInfFolder.getFile("QueryService.wsdl");
		InputStream fileContents = file.getContents();
		String serviceName = null;
		try {
			BufferedReader reader = new BufferedReader(new InputStreamReader(fileContents));
			String line = null;
			while ((line = reader.readLine()) != null) {
				if (line.contains("<wsdl:service name=\"")) {
					String rightSide = line.substring(line.indexOf('\"')+1);
					int rightQuote = rightSide.indexOf('\"');
					serviceName = rightSide.substring(0, rightQuote);
					break;
				}
			}
			reader.close();
			fileContents.close();
		} catch (IOException e) {
			throw DMJ2EEPlugin.createCoreException(e);
		}
		return serviceName;
	}

	public void serverChanged(ServerEvent event) {
		if (event.getState() == IServer.STATE_STARTED) {
			Display.getDefault().syncExec(new Runnable() {
				public void run() {
					try {
						buildEprAndLaunchViewer();
					} catch (CoreException e) {
						e.printStackTrace();
					}
				}
			});
		}
	}

	private void setServer(IServer server) {
		this.server = server;
	}

	private IServer getServer() {
		return server;
	}

	private void setModuleArtifact(IModuleArtifact moduleArtifact) {
		this.moduleArtifact = moduleArtifact;
	}

	private IModuleArtifact getModuleArtifact() {
		return moduleArtifact;
	}

}
