/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;

public class ConglomerateDescriptorList
extends ArrayList {
    public ConglomerateDescriptor getConglomerateDescriptor(long conglomerateNumber) {
        ConglomerateDescriptor returnValue = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)this.get(index);
            if (conglomerateNumber != conglomerateDescriptor.getConglomerateNumber()) continue;
            returnValue = conglomerateDescriptor;
            break;
        }
        return returnValue;
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(long conglomerateNumber) {
        int size = this.size();
        int j = 0;
        ConglomerateDescriptor[] draft = new ConglomerateDescriptor[size];
        for (int index = 0; index < size; ++index) {
            ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)this.get(index);
            if (conglomerateNumber != conglomerateDescriptor.getConglomerateNumber()) continue;
            draft[j++] = conglomerateDescriptor;
        }
        if (j == size) {
            return draft;
        }
        ConglomerateDescriptor[] returnValue = new ConglomerateDescriptor[j];
        for (int i = 0; i < j; ++i) {
            returnValue[i] = draft[i];
        }
        return returnValue;
    }

    public ConglomerateDescriptor getConglomerateDescriptor(String conglomerateName) {
        ConglomerateDescriptor returnValue = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)this.get(index);
            if (!conglomerateName.equals(conglomerateDescriptor.getConglomerateName())) continue;
            returnValue = conglomerateDescriptor;
            break;
        }
        return returnValue;
    }

    public ConglomerateDescriptor getConglomerateDescriptor(UUID uuid) throws StandardException {
        ConglomerateDescriptor returnValue = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)this.get(index);
            if (!uuid.equals(conglomerateDescriptor.getUUID())) continue;
            returnValue = conglomerateDescriptor;
            break;
        }
        return returnValue;
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(UUID uuid) {
        int size = this.size();
        int j = 0;
        ConglomerateDescriptor[] draft = new ConglomerateDescriptor[size];
        for (int index = 0; index < size; ++index) {
            ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)this.get(index);
            if (!uuid.equals(conglomerateDescriptor.getUUID())) continue;
            draft[j++] = conglomerateDescriptor;
        }
        if (j == size) {
            return draft;
        }
        ConglomerateDescriptor[] returnValue = new ConglomerateDescriptor[j];
        for (int i = 0; i < j; ++i) {
            returnValue[i] = draft[i];
        }
        return returnValue;
    }

    public void dropConglomerateDescriptor(UUID tableID, ConglomerateDescriptor cgDesc) throws StandardException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ConglomerateDescriptor localCgDesc = (ConglomerateDescriptor)iterator.next();
            if (localCgDesc.getConglomerateNumber() != cgDesc.getConglomerateNumber() || !localCgDesc.getConglomerateName().equals(cgDesc.getConglomerateName()) || !localCgDesc.getSchemaID().equals(cgDesc.getSchemaID())) continue;
            iterator.remove();
            break;
        }
    }

    public void dropConglomerateDescriptorByUUID(UUID conglomerateID) throws StandardException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ConglomerateDescriptor localCgDesc = (ConglomerateDescriptor)iterator.next();
            if (!conglomerateID.equals(localCgDesc.getUUID())) continue;
            iterator.remove();
            break;
        }
    }
}

