/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

public class BaseColumnNode
extends ValueNode {
    private String columnName;
    private TableName tableName;

    public void init(Object columnName, Object tableName, Object dts) throws StandardException {
        this.columnName = (String)columnName;
        this.tableName = (TableName)tableName;
        this.setType((DataTypeDescriptor)dts);
    }

    public String toString() {
        return "columnName: " + this.columnName + "\n" + (this.tableName != null ? this.tableName.toString() : "tableName: null\n") + super.toString();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName != null ? this.tableName.getTableName() : null;
    }

    public String getSchemaName() throws StandardException {
        return this.tableName != null ? this.tableName.getSchemaName() : null;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        throw StandardException.newException("42Z50", this.nodeHeader());
    }

    protected int getOrderableVariantType() {
        return 1;
    }

    protected boolean isEquivalent(ValueNode o) {
        if (this.isSameNodeType(o)) {
            BaseColumnNode other = (BaseColumnNode)o;
            return other.tableName.equals(other.tableName) && other.columnName.equals(this.columnName);
        }
        return false;
    }
}

