/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.ForeignKeyRIChecker;
import org.apache.derby.impl.sql.execute.GenericRIChecker;
import org.apache.derby.impl.sql.execute.ReferencedKeyRIChecker;

public class RISetChecker {
    private GenericRIChecker[] checkers;

    public RISetChecker(TransactionController tc, FKInfo[] fkInfo) throws StandardException {
        if (fkInfo == null) {
            return;
        }
        this.checkers = new GenericRIChecker[fkInfo.length];
        for (int i = 0; i < fkInfo.length; ++i) {
            this.checkers[i] = fkInfo[i].type == 1 ? new ForeignKeyRIChecker(tc, fkInfo[i]) : new ReferencedKeyRIChecker(tc, fkInfo[i]);
        }
    }

    void reopen() throws StandardException {
    }

    public void doPKCheck(ExecRow row, boolean restrictCheckOnly) throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (int i = 0; i < this.checkers.length; ++i) {
            if (!(this.checkers[i] instanceof ReferencedKeyRIChecker)) continue;
            this.checkers[i].doCheck(row, restrictCheckOnly);
        }
    }

    public void doFKCheck(ExecRow row) throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (int i = 0; i < this.checkers.length; ++i) {
            if (!(this.checkers[i] instanceof ForeignKeyRIChecker)) continue;
            this.checkers[i].doCheck(row);
        }
    }

    public void doRICheck(int index, ExecRow row, boolean restrictCheckOnly) throws StandardException {
        if (this.checkers == null) {
            SanityManager.THROWASSERT("no checkers, how can i execute checker " + index);
        }
        if (index >= this.checkers.length) {
            SanityManager.THROWASSERT("there are only " + this.checkers.length + " checkers, " + index + " is invalid");
        }
        this.checkers[index].doCheck(row, restrictCheckOnly);
    }

    public void close() throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (int i = 0; i < this.checkers.length; ++i) {
            this.checkers[i].close();
        }
    }
}

