/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.DMLWriteResultSet;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.RISetChecker;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.TriggerEventActivator;
import org.apache.derby.impl.sql.execute.TriggerEvents;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.UpdateConstantAction;
import org.apache.derby.impl.sql.execute.ValueRow;

class UpdateResultSet
extends DMLWriteResultSet {
    private TransactionController tc;
    private ExecRow newBaseRow;
    private ExecRow row;
    private ExecRow deferredSparseRow;
    UpdateConstantAction constants;
    private NoPutResultSet source;
    NoPutResultSet savedSource;
    private RowChanger rowChanger;
    protected ConglomerateController deferredBaseCC;
    protected long[] deferredUniqueCIDs;
    protected boolean[] deferredUniqueCreated;
    protected ConglomerateController[] deferredUniqueCC;
    protected ScanController[] deferredUniqueScans;
    private TemporaryRowHolderImpl deletedRowHolder;
    private TemporaryRowHolderImpl insertedRowHolder;
    private RISetChecker riChecker;
    private TriggerInfo triggerInfo;
    private TriggerEventActivator triggerActivator;
    private boolean updatingReferencedKey;
    private boolean updatingForeignKey;
    private int numOpens;
    private long heapConglom;
    private FKInfo[] fkInfoArray;
    private FormatableBitSet baseRowReadList;
    private GeneratedMethod generationClauses;
    private GeneratedMethod checkGM;
    private int resultWidth;
    private int numberOfBaseColumns;
    private ExecRow deferredTempRow;
    private ExecRow deferredBaseRow;
    private ExecRow oldDeletedRow;
    int lockMode;
    boolean deferred;
    boolean beforeUpdateCopyRequired = false;

    UpdateResultSet(NoPutResultSet source, GeneratedMethod generationClauses, GeneratedMethod checkGM, Activation activation) throws StandardException {
        this(source, generationClauses, checkGM, activation, activation.getConstantAction(), null);
    }

    UpdateResultSet(NoPutResultSet source, GeneratedMethod generationClauses, GeneratedMethod checkGM, Activation activation, int constantActionItem, int rsdItem) throws StandardException {
        this(source, generationClauses, checkGM, activation, (ConstantAction)activation.getPreparedStatement().getSavedObject(constantActionItem), (ResultDescription)activation.getPreparedStatement().getSavedObject(rsdItem));
        this.deferred = true;
    }

    UpdateResultSet(NoPutResultSet source, GeneratedMethod generationClauses, GeneratedMethod checkGM, Activation activation, ConstantAction passedInConstantAction, ResultDescription passedInRsd) throws StandardException {
        super(activation, passedInConstantAction);
        this.tc = activation.getTransactionController();
        this.source = source;
        this.generationClauses = generationClauses;
        this.checkGM = checkGM;
        this.constants = (UpdateConstantAction)this.constantAction;
        this.fkInfoArray = this.constants.getFKInfo();
        this.triggerInfo = this.constants.getTriggerInfo();
        this.heapConglom = this.constants.conglomId;
        this.baseRowReadList = this.constants.getBaseRowReadList();
        ResultDescription resultDescription = passedInRsd == null ? activation.getResultDescription() : passedInRsd;
        if (resultDescription == null) {
            SanityManager.ASSERT(this.triggerInfo == null, "triggers need a result description to pass to result sets given to users");
        }
        if (this.fkInfoArray != null) {
            for (int i = 0; i < this.fkInfoArray.length; ++i) {
                if (this.fkInfoArray[i].type == 2) {
                    this.updatingReferencedKey = true;
                    SanityManager.ASSERT(this.constants.deferred, "updating referenced key but update not deferred, wuzzup?");
                    continue;
                }
                this.updatingForeignKey = true;
            }
        }
        this.resultWidth = resultDescription.getColumnCount();
        this.numberOfBaseColumns = (this.resultWidth - 1) / 2;
        this.newBaseRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns, this.lcc);
        this.deferred = this.constants.deferred;
        if (this.triggerInfo != null || this.fkInfoArray != null) {
            this.beforeUpdateCopyRequired = true;
        }
    }

    public void open() throws StandardException {
        this.setup();
        this.collectAffectedRows();
        if (this.deferred) {
            this.runChecker(true);
            this.fireBeforeTriggers();
            this.updateDeferredRows();
            this.rowChanger.finish();
            this.runChecker(false);
            this.fireAfterTriggers();
        } else {
            this.rowChanger.finish();
        }
        this.cleanUp();
    }

    void setup() throws StandardException {
        super.setup();
        this.lockMode = this.decodeLockMode(this.constants.lockMode);
        boolean firstOpen = this.rowChanger == null;
        this.rowCount = 0;
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.source;
        }
        if (firstOpen) {
            this.rowChanger = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getRowChanger(this.heapConglom, this.constants.heapSCOCI, this.heapDCOCI, this.constants.irgs, this.constants.indexCIDS, this.constants.indexSCOCIs, this.indexDCOCIs, this.constants.numColumns, this.tc, this.constants.changedColumnIds, this.constants.getBaseRowReadList(), this.constants.getBaseRowReadMap(), this.constants.getStreamStorableHeapColIds(), this.activation);
            this.rowChanger.setIndexNames(this.constants.indexNames);
        } else {
            this.lcc.getStatementContext().setTopResultSet(this, this.subqueryTrackingArray);
        }
        this.rowChanger.open(this.lockMode);
        if (this.numOpens++ == 0) {
            this.source.openCore();
        } else {
            this.source.reopenCore();
        }
        if (this.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (this.fkInfoArray != null) {
            if (this.riChecker == null) {
                this.riChecker = new RISetChecker(this.tc, this.fkInfoArray);
            } else {
                this.riChecker.reopen();
            }
        }
        if (this.deferred) {
            if (firstOpen) {
                this.deferredTempRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns + 1, this.lcc);
                this.oldDeletedRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns, this.lcc);
            }
            Properties properties = new Properties();
            this.rowChanger.getHeapConglomerateController().getInternalTablePropertySet(properties);
            if (this.beforeUpdateCopyRequired) {
                this.deletedRowHolder = new TemporaryRowHolderImpl(this.activation, properties);
            }
            this.insertedRowHolder = new TemporaryRowHolderImpl(this.activation, properties);
            this.rowChanger.setRowHolder(this.insertedRowHolder);
        }
    }

    private FormatableBitSet checkStreamCols() {
        DataValueDescriptor[] cols = this.row.getRowArray();
        FormatableBitSet streamCols = null;
        for (int i = 0; i < this.numberOfBaseColumns; ++i) {
            if (!(cols[i + this.numberOfBaseColumns] instanceof StreamStorable)) continue;
            if (streamCols == null) {
                streamCols = new FormatableBitSet(this.numberOfBaseColumns);
            }
            streamCols.set(i);
        }
        return streamCols;
    }

    private void objectifyStream(ExecRow tempRow, FormatableBitSet streamCols) throws StandardException {
        DataValueDescriptor[] cols = tempRow.getRowArray();
        for (int i = 0; i < this.numberOfBaseColumns; ++i) {
            if (cols[i] == null || !streamCols.get(i)) continue;
            ((StreamStorable)((Object)cols[i])).loadStream();
        }
    }

    public boolean collectAffectedRows() throws StandardException {
        boolean rowsFound = false;
        this.row = this.getNextRowCore(this.source);
        if (this.row != null) {
            rowsFound = true;
        } else {
            this.activation.addWarning(StandardException.newWarning("02000"));
        }
        TableScanResultSet tableScan = (TableScanResultSet)this.activation.getForUpdateIndexScan();
        boolean notifyCursor = tableScan != null && !tableScan.sourceDrained;
        boolean checkStream = this.deferred && rowsFound && !this.constants.singleRowSource;
        FormatableBitSet streamCols = checkStream ? this.checkStreamCols() : null;
        boolean bl = checkStream = streamCols != null;
        while (this.row != null) {
            this.evaluateGenerationClauses(this.generationClauses, this.activation, this.source, this.row, true);
            if (this.deferred) {
                if (this.triggerInfo == null) {
                    UpdateResultSet.evaluateCheckConstraints(this.checkGM, this.activation);
                }
                RowUtil.copyRefColumns(this.deferredTempRow, this.row, this.numberOfBaseColumns, this.numberOfBaseColumns + 1);
                if (checkStream) {
                    this.objectifyStream(this.deferredTempRow, streamCols);
                }
                this.insertedRowHolder.insert(this.deferredTempRow);
                if (this.beforeUpdateCopyRequired) {
                    RowUtil.copyRefColumns(this.oldDeletedRow, this.row, this.numberOfBaseColumns);
                    this.deletedRowHolder.insert(this.oldDeletedRow);
                }
                if (this.deferredBaseRow == null) {
                    this.deferredBaseRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns, this.lcc);
                    RowUtil.copyCloneColumns(this.deferredBaseRow, this.row, this.numberOfBaseColumns);
                    this.deferredSparseRow = this.makeDeferredSparseRow(this.deferredBaseRow, this.baseRowReadList, this.lcc);
                }
            } else {
                UpdateResultSet.evaluateCheckConstraints(this.checkGM, this.activation);
                RowLocation baseRowLocation = (RowLocation)this.row.getColumn(this.resultWidth).getObject();
                RowUtil.copyRefColumns(this.newBaseRow, this.row, this.numberOfBaseColumns, this.numberOfBaseColumns);
                if (this.riChecker != null) {
                    this.riChecker.doFKCheck(this.newBaseRow);
                }
                this.source.updateRow(this.newBaseRow);
                this.rowChanger.updateRow(this.row, this.newBaseRow, baseRowLocation);
                if (notifyCursor) {
                    this.notifyForUpdateCursor(this.row.getRowArray(), this.newBaseRow.getRowArray(), baseRowLocation, tableScan);
                }
            }
            ++this.rowCount;
            if (this.constants.singleRowSource) {
                this.row = null;
                continue;
            }
            this.row = this.getNextRowCore(this.source);
        }
        return rowsFound;
    }

    private void notifyForUpdateCursor(DataValueDescriptor[] row, DataValueDescriptor[] newBaseRow, RowLocation rl, TableScanResultSet tableScan) throws StandardException {
        int[] indexCols = tableScan.indexCols;
        int[] changedCols = this.constants.changedColumnIds;
        boolean placedForward = false;
        boolean decided = false;
        boolean overlap = false;
        for (int i = 0; i < indexCols.length; ++i) {
            boolean ascending;
            int basePos = indexCols[i];
            if (basePos > 0) {
                ascending = true;
            } else {
                ascending = false;
                basePos = -basePos;
            }
            for (int j = 0; j < changedCols.length; ++j) {
                if (basePos != changedCols[j]) continue;
                decided = true;
                int[] map = this.constants.getBaseRowReadMap();
                int k = map == null ? basePos - 1 : map[basePos - 1];
                DataValueDescriptor key = tableScan.compareToLastKey ? tableScan.lastCursorKey.getColumn(i + 1) : row[k];
                if (ascending && key.greaterThan(newBaseRow[k], key).equals(true) || !ascending && key.lessThan(newBaseRow[k], key).equals(true)) {
                    placedForward = true;
                    break;
                }
                if (!key.equals(newBaseRow[k], key).equals(true)) break;
                decided = false;
                overlap = true;
                break;
            }
            if (decided) break;
        }
        if (overlap && !decided) {
            placedForward = true;
        }
        if (placedForward) {
            int maxCapacity = this.lcc.getOptimizerFactory().getMaxMemoryPerTable() / 16;
            if (maxCapacity < 100) {
                maxCapacity = 100;
            }
            if (tableScan.past2FutureTbl == null) {
                double rowCount = tableScan.getEstimatedRowCount();
                int initCapacity = 32768;
                if (rowCount > 0.0 && (rowCount = rowCount / 0.75 + 1.0) < (double)initCapacity) {
                    initCapacity = (int)rowCount;
                }
                if (maxCapacity < initCapacity) {
                    initCapacity = maxCapacity;
                }
                tableScan.past2FutureTbl = new Hashtable(initCapacity);
            }
            Hashtable past2FutureTbl = tableScan.past2FutureTbl;
            RowLocation updatedRL = (RowLocation)rl.getClone();
            if (past2FutureTbl.size() < maxCapacity) {
                past2FutureTbl.put(updatedRL, updatedRL);
            } else {
                block17: {
                    ExecRow aRow;
                    tableScan.skipFutureRowHolder = true;
                    ValueRow rlRow = new ValueRow(1);
                    do {
                        if ((aRow = tableScan.getNextRowCore()) == null) {
                            tableScan.sourceDrained = true;
                            tableScan.past2FutureTbl = null;
                            break block17;
                        }
                        RowLocation rowLoc = (RowLocation)aRow.getColumn(aRow.nColumns());
                        if (updatedRL.equals(rowLoc)) {
                            this.saveLastCusorKey(tableScan, aRow);
                            break block17;
                        }
                        if (tableScan.futureForUpdateRows == null) {
                            tableScan.futureForUpdateRows = new TemporaryRowHolderImpl(this.activation, null, 100, false, true);
                        }
                        rlRow.setColumn(1, rowLoc);
                        tableScan.futureForUpdateRows.insert(rlRow);
                    } while (past2FutureTbl.size() >= maxCapacity);
                    past2FutureTbl.put(updatedRL, updatedRL);
                    this.saveLastCusorKey(tableScan, aRow);
                }
                tableScan.skipFutureRowHolder = false;
            }
        }
    }

    private void saveLastCusorKey(TableScanResultSet tableScan, ExecRow aRow) throws StandardException {
        if (tableScan.lastCursorKey == null) {
            tableScan.lastCursorKey = new ValueRow(aRow.nColumns() - 1);
        }
        for (int i = 1; i <= tableScan.lastCursorKey.nColumns(); ++i) {
            DataValueDescriptor aCol = aRow.getColumn(i);
            if (aCol == null) continue;
            tableScan.lastCursorKey.setColumn(i, aCol.getClone());
        }
    }

    void fireBeforeTriggers() throws StandardException {
        if (this.deferred && this.triggerInfo != null) {
            if (this.triggerActivator == null) {
                this.triggerActivator = new TriggerEventActivator(this.lcc, this.tc, this.constants.targetUUID, this.triggerInfo, 1, this.activation, null);
            } else {
                this.triggerActivator.reopen();
            }
            this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_UPDATE, this.deletedRowHolder.getResultSet(), this.insertedRowHolder.getResultSet());
        }
    }

    void fireAfterTriggers() throws StandardException {
        if (this.deferred && this.triggerActivator != null) {
            this.triggerActivator.notifyEvent(TriggerEvents.AFTER_UPDATE, this.deletedRowHolder.getResultSet(), this.insertedRowHolder.getResultSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDeferredRows() throws StandardException {
        if (this.deferred) {
            this.deferredBaseCC = this.tc.openCompiledConglomerate(false, 4 | 0x2000, this.lockMode, 5, this.constants.heapSCOCI, this.heapDCOCI);
            CursorResultSet rs = this.insertedRowHolder.getResultSet();
            try {
                ExecRow deferredTempRow2;
                FormatableBitSet readBitSet = RowUtil.shift(this.baseRowReadList, 1);
                rs.open();
                while ((deferredTempRow2 = rs.getNextRow()) != null) {
                    if (this.triggerInfo != null) {
                        this.source.setCurrentRow(this.deferredTempRow);
                        UpdateResultSet.evaluateCheckConstraints(this.checkGM, this.activation);
                    }
                    DataValueDescriptor rlColumn = deferredTempRow2.getColumn(this.numberOfBaseColumns + 1);
                    RowLocation baseRowLocation = (RowLocation)rlColumn.getObject();
                    boolean row_exists = this.deferredBaseCC.fetch(baseRowLocation, this.deferredSparseRow.getRowArray(), readBitSet);
                    SanityManager.ASSERT(row_exists, "did not find base row in deferred update");
                    RowUtil.copyRefColumns(this.newBaseRow, deferredTempRow2, this.numberOfBaseColumns);
                    this.rowChanger.updateRow(this.deferredBaseRow, this.newBaseRow, baseRowLocation);
                    this.source.updateRow(this.newBaseRow);
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.source.clearCurrentRow();
                rs.close();
                throw throwable;
            }
            this.source.clearCurrentRow();
            rs.close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runChecker(boolean restrictCheckOnly) throws StandardException {
        int i;
        if (this.deferred && this.updatingReferencedKey) {
            for (i = 0; i < this.fkInfoArray.length; ++i) {
                Object var6_5;
                if (this.fkInfoArray[i].type == 1) continue;
                CursorResultSet deletedRows = this.deletedRowHolder.getResultSet();
                try {
                    ExecRow deletedRow;
                    deletedRows.open();
                    while ((deletedRow = deletedRows.getNextRow()) != null) {
                        if (UpdateResultSet.foundRow(deletedRow, this.fkInfoArray[i].colArray, this.insertedRowHolder)) continue;
                        this.riChecker.doRICheck(i, deletedRow, restrictCheckOnly);
                    }
                    var6_5 = null;
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    deletedRows.close();
                    throw throwable;
                }
                deletedRows.close();
                {
                    continue;
                }
            }
        }
        if (this.deferred && this.updatingForeignKey) {
            for (i = 0; i < this.fkInfoArray.length; ++i) {
                Object var8_7;
                if (this.fkInfoArray[i].type == 2) continue;
                CursorResultSet insertedRows = this.insertedRowHolder.getResultSet();
                try {
                    ExecRow insertedRow;
                    insertedRows.open();
                    while ((insertedRow = insertedRows.getNextRow()) != null) {
                        if (UpdateResultSet.foundRow(insertedRow, this.fkInfoArray[i].colArray, this.deletedRowHolder)) continue;
                        this.riChecker.doRICheck(i, insertedRow, restrictCheckOnly);
                    }
                    var8_7 = null;
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    insertedRows.close();
                    throw throwable;
                }
                insertedRows.close();
                {
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean foundRow(ExecRow checkRow, int[] colsToCheck, TemporaryRowHolderImpl rowHolder) throws StandardException {
        boolean foundMatch = false;
        DataValueDescriptor[] checkRowArray = checkRow.getRowArray();
        CursorResultSet rs = rowHolder.getResultSet();
        try {
            ExecRow scanRow;
            rs.open();
            while ((scanRow = rs.getNextRow()) != null) {
                DataValueDescriptor scanCol;
                DataValueDescriptor checkCol;
                BooleanDataValue result;
                int i;
                DataValueDescriptor[] scanRowArray = scanRow.getRowArray();
                for (i = 0; i < colsToCheck.length && (result = (checkCol = checkRowArray[colsToCheck[i] - 1]).equals(scanCol = scanRowArray[colsToCheck[i] - 1], checkCol)).getBoolean(); ++i) {
                }
                if (i != colsToCheck.length) continue;
                foundMatch = true;
                break;
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            rs.close();
            throw throwable;
        }
        rs.close();
        return foundMatch;
    }

    public void cleanUp() throws StandardException {
        this.numOpens = 0;
        if (this.source != null) {
            this.source.close();
        }
        if (this.triggerActivator != null) {
            this.triggerActivator.cleanup();
        }
        if (this.rowChanger != null) {
            this.rowChanger.close();
        }
        if (this.deferredBaseCC != null) {
            this.deferredBaseCC.close();
        }
        this.deferredBaseCC = null;
        if (this.insertedRowHolder != null) {
            this.insertedRowHolder.close();
        }
        if (this.deletedRowHolder != null) {
            this.deletedRowHolder.close();
        }
        if (this.riChecker != null) {
            this.riChecker.close();
        }
        super.close();
        this.endTime = this.getCurrentTimeMillis();
    }

    void rowChangerFinish() throws StandardException {
        this.rowChanger.finish();
    }
}

