/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.repository.operations;

import org.eclipse.cosmos.rm.provisional.repository.operations.IProgressListener;

public abstract class AbstractListenerManager {
    private IProgressListener[] listeners;

    public void addProgressListener(IProgressListener listener) {
        IProgressListener[] oldListeners = this.listeners;
        this.listeners = new IProgressListener[this.listeners == null ? 1 : this.listeners.length + 1];
        if (oldListeners != null) {
            System.arraycopy(oldListeners, 0, this.listeners, 0, oldListeners.length);
        }
        this.listeners[this.listeners.length - 1] = listener;
    }

    public void removeProgressListener(IProgressListener listener) {
        int inx = -1;
        int i = 0;
        while (i < this.listeners.length) {
            if (this.listeners[i] == listener) {
                inx = i;
                break;
            }
            ++i;
        }
        if (inx < 0) {
            return;
        }
        IProgressListener[] newListeners = this.listeners;
        this.listeners = new IProgressListener[this.listeners.length - 1];
        System.arraycopy(newListeners, 0, this.listeners, 0, inx);
        System.arraycopy(newListeners, inx + 1, this.listeners, inx, newListeners.length - (inx + 1));
    }

    protected IProgressListener[] getProgressListeners() {
        return this.listeners;
    }
}

