/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementModel;
import org.eclipse.cosmos.rm.internal.validation.artifacts.MappedNamespaceContext;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementSchemaModel
extends ElementModel {
    private String targetNamespace;
    private MappedNamespaceContext namespaceContext = new MappedNamespaceContext();
    private boolean validated = false;
    private List<String> imported = new ArrayList<String>();

    public ElementSchemaModel(String name, String filePath, int lineNumber, int columnNumber) {
        super(name, filePath, lineNumber, columnNumber);
    }

    public ElementSchemaModel(Node node, String filePath, int lineNumber, int columnNumber) {
        super(node, filePath, lineNumber, columnNumber);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", targetNamespace=" + this.getTargetNamespace();
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public boolean hasBeenValidated() {
        return this.validated;
    }

    public void markValidated() {
        this.validated = true;
    }

    public void addImportedSchema(String namespace) {
        this.imported.add(namespace);
    }

    public List<String> getImportedSchemas() {
        return this.imported;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ElementSchemaModel)) {
            return false;
        }
        ElementSchemaModel elementSchemaModel = (ElementSchemaModel)o;
        return elementSchemaModel.getTargetNamespace().equals(this.getTargetNamespace()) && super.equals(o);
    }

    public MappedNamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setNamespaceContext(MappedNamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }
}

