/**********************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * CA - Initial API and implementation
 * IBM - provisional API change, removed IRootElement
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Represents a <xpathSupport> element in XML form
 * 
 * 
 * @author Bill Muldoon
 */
public interface IXpathSupport extends IXMLWritable
{
	/**
	 * add a dialect to the xpathSupport
	 * 
	 * @param dialect
	 */
	public void addDialect(IDialect dialect);
	
	/**
	 * get a collection of dialects
	 * 
	 */
	public IDialect[] getDialects();

}
