/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.repository.operations;

import org.eclipse.cosmos.rm.provisional.repository.operations.IProgressListener;


/**
 * Keeps track of the operation listeners.  This class is only meant 
 * to be extended.
 * 
 * @author Ali Mehregani
 */
public abstract class AbstractListenerManager
{
	/**
	 * The progress listeners of this operation
	 */
	private IProgressListener[] listeners;
	
	/**
	 * @see org.eclipse.cosmos.rm.provisional.repository.operations.ISMLOperation#addProgressListener(org.eclipse.cosmos.rm.provisional.repository.operations.IProgressListener)
	 */
	public void addProgressListener(IProgressListener listener)
	{
		IProgressListener[] oldListeners = listeners;
		listeners = new IProgressListener[listeners == null ? 1 : listeners.length + 1];
		if (oldListeners != null)
			System.arraycopy(oldListeners, 0, listeners, 0, oldListeners.length);
		
		listeners[listeners.length - 1] = listener;
	}
	
	
	/**
	 * @see org.eclipse.cosmos.rm.provisional.repository.operations.ISMLOperation#removeProgressListener(org.eclipse.cosmos.rm.provisional.repository.operations.IProgressListener)
	 */
	public void removeProgressListener(IProgressListener listener)
	{
		int inx = -1;
		for (int i = 0; i < listeners.length; i++)
		{
			if (listeners[i] == listener)
			{
				inx = i;
				break;
			}			
		}
		
		if (inx < 0)
			return;
		
		IProgressListener[] newListeners = listeners;
		listeners = new IProgressListener[listeners.length - 1];
		System.arraycopy(newListeners, 0, listeners, 0, inx);
		System.arraycopy(newListeners, inx + 1, listeners, inx, newListeners.length - (inx+1));		
	}
	
	
	/**
	 * Returns the progress listeners of this operation
	 * 
	 * @return The progress listeners
	 */
	protected IProgressListener[] getProgressListeners()
	{
		return listeners;
	}
}
