/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.reference;

import javax.xml.namespace.NamespaceContext;

import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.databuilders.NamespaceContextBuilder;

/**
 * The XPointer scheme is used to evaluate the parenthesized expressions that
 * appears after the keyword xpointer in an XPointer expression.
 * 
 * @author Ali Mehregani
 */
public class XPointerScheme extends AbstractScheme
{
	/**
	 * Represents the keyword to identify this scheme
	 */
	public static final String SCHEME = "xpointer";

	/**
	 * @see org.eclipse.cosmos.rm.internal.validation.reference.IXScheme#evaluate(java.lang.Object)
	 */
	public Object evaluate(Object context) throws BadExpressionException
	{		
        Object namespaceContext = SMLValidatorUtil.retrieveDataStructure(NamespaceContextBuilder.ID);
        if (namespaceContext instanceof NamespaceContext)
        	setNamespaceContext((NamespaceContext)namespaceContext);
                
        return super.evaluate(context);
	}	

	/**
	 * @see org.eclipse.cosmos.rm.internal.validation.reference.IXScheme#getType()
	 */
	public String getType()
	{
		return SCHEME;
	}
}
