/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.smlif.export.ui;

import org.eclipse.cosmos.rm.internal.validation.common.ISMLConstants;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * SAX Handler for parsing a definition document to detect Schematron rules
 * 
 * @author David Whiteman
 */
public class RuleFindingFileHandler extends DefaultHandler {

	private boolean hasRule;

	public void characters(char[] ch, int start, int length)
			throws SAXException {
		super.characters(ch, start, length);
	}

	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		super.endElement(uri, localName, qName);
	}

	private boolean isSchematronRuleElement(String uri, String localName) {
		return ISMLConstants.RULE_ELEMENT.equals(localName)
				&& ISMLConstants.SCHEMATRON_URI.equals(uri);
	}

	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		if (isSchematronRuleElement(uri, localName)) {
			hasRule = true;
		}
		super.startElement(uri, localName, qName, attributes);
	}

	public boolean hasRule() {
		return hasRule;
	}

}
