/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.IQueryTransformerConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.artifacts.IContentSelector;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.ISelectedRecordType;

/**
 * Allows query to specify the specific properties to be returned in
 * the query result
 * 
 * @author David Whiteman
 */
public class ContentSelector implements IContentSelector {
	private static final boolean DEFAULT_MATCHED_RECORDS = true;
	private List<ISelectedRecordType> selectedRecordTypes = new ArrayList<ISelectedRecordType>(); // 0 or more
	private Boolean matchedRecords = null;

	public ISelectedRecordType[] getSelectedRecordTypes() {
		return selectedRecordTypes.toArray(new ISelectedRecordType[selectedRecordTypes.size()]);
	}
	
	public void addSelectedRecordType(ISelectedRecordType selectedRecordType) {
		selectedRecordTypes.add(selectedRecordType);
	}

	public void toXML(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(ICMDBfServicesConstants.OPEN_ANGLE_BRACKET+ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.CONTENT_SELECTOR_ELEMENT);
		if (matchedRecords != null) {
			writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
			CMDBfServicesUtil.writeAttribute(writer, IQueryTransformerConstants.MATCHED_RECORDS_ATTRIBUTE, matchedRecords.toString());
		}
		writer.write(ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET + ICMDBfServicesConstants.nl);
		
		CMDBfServicesUtil.outputListToXML(writer, indent+1, selectedRecordTypes);

		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.CONTENT_SELECTOR_ELEMENT)+ICMDBfServicesConstants.nl);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((matchedRecords == null) ? 0 : matchedRecords.hashCode());
		result = prime
				* result
				+ ((selectedRecordTypes == null) ? 0 : selectedRecordTypes
						.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final ContentSelector other = (ContentSelector) obj;
		if (matchedRecords == null) {
			if (other.matchedRecords != null)
				return false;
		} else if (!matchedRecords.equals(other.matchedRecords))
			return false;
		if (selectedRecordTypes == null) {
			if (other.selectedRecordTypes != null)
				return false;
		} else if (!selectedRecordTypes.equals(other.selectedRecordTypes))
			return false;
		return true;
	}

	public boolean isMatchedRecords() {
		return (matchedRecords == null) ? DEFAULT_MATCHED_RECORDS : matchedRecords;
	}

	public void setMatchedRecords(boolean matchedRecords) {
		this.matchedRecords = matchedRecords;
	}
}
