/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.profile.cim.op;

import java.io.File;

import javax.xml.namespace.QName;

import org.eclipse.cosmos.me.sdd.op.IOperationHandler;
import org.eclipse.cosmos.me.sdd.schema.AdditionalContentType;
import org.eclipse.cosmos.me.sdd.schema.ArtifactType;
import org.eclipse.cosmos.me.sdd.schema.OperationType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public class DirectoryOperation implements IOperationHandler {
	static final QName DIR = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_Directory");

	public void invokeAction(SDDContext ctxt, ArtifactType artifact, OperationType operation) {
		switch (operation) {
		case UNINSTALL: {
			uninstall(ctxt, artifact);
		} break;
		}
	}

	public void invokeAction(SDDContext ctxt, ArtifactType artifact, AdditionalContentType content,
			OperationType operation) {
	}

	private void uninstall(SDDContext ctxt, ArtifactType artifact) {
		if (artifact.getResourceRef() != null) {
			ResourceType r = (ResourceType)artifact.getResourceRef();
			if (DIR.equals(r.getType())) {
				deleteDirectory(ctxt.substituteVariables(r.getName()));
			}
		}
	}

	private void deleteDirectory(String path) {
		File installDir = new File(path);
		if (installDir.exists() && installDir.isDirectory()) {
			delete(installDir);
		}
	}

	private void delete(File file) {
		if (file.exists()) {
			for (File f : file.listFiles()) {
				if (f.isDirectory())
					delete(f);
				else
					f.delete();
			}
			file.delete();
		}
	}
}
