/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.cli.equinox;

import org.eclipse.cosmos.me.sdd.o10r.Orchestrator;
import org.eclipse.cosmos.me.sdd.op.listener.EntryData;
import org.eclipse.cosmos.me.sdd.op.listener.InstallationProgressListener;
import org.eclipse.cosmos.me.sdd.op.listener.event.IRegistry;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.service.component.ComponentContext;

public class Sdd implements CommandProvider {
	private Orchestrator orchestrator;
	private IRegistry registry;
	private InstallationProgressListener progressListener;

	public void setOrchestrator(Orchestrator orchestrator) {
		this.orchestrator = orchestrator;
	}

	public void unsetOrchestrator(Orchestrator orchestrator) {
		this.orchestrator = null;
	}
	
	public void setRegistry(IRegistry registry) {
		this.registry = registry;
	}
	
	protected void activate(ComponentContext ctxt) {
		progressListener = createProgressListener();
		registry.addListener(progressListener);
	}
	
	protected void deactivate(ComponentContext ctxt) {
		registry.removeListener(progressListener);
		progressListener = null;
	}
	
	public void unsetRegistry(IRegistry registry) {
		this.registry = null;
	}
	
	public void _sdd(CommandInterpreter ci) {
		String operation = ci.nextArgument();
		String uri = ci.nextArgument();
		if (operation != null && uri != null) {
			orchestrator.deploy(uri, operation);
		} else {
			ci.println("Usage:" + getHelp());
		}
	}
	
	public String getHelp() {
		return "---SDD Runtime commands---\n\tsdd <operation> <pkg. desc.>\n";
	}

	private InstallationProgressListener createProgressListener() {
		return new InstallationProgressListener() {
			public void bytesMoved(long numBytes) {
				//System.out.printf("bytesMoved - %d\n", numBytes);
			}

			public void progressBeginningAction(String action,
					EntryData metaData) {
				//System.out.printf("progressBeginningAction - %s %s\n", action, metaData);
			}

			public void progressBeginningAction(String description) {
				//System.out.printf("progressBeginningAction - %s\n", description);
			}

			public void progressCompleteAction(String action, EntryData metaData) {
				//System.out.printf("progressCompleteAction - %s %s\n", action, metaData);
			}

			public void progressCompleteAction(String description) {
				//System.out.printf("progressCompleteAction - %s\n", description);
			}

			public void progressFailedAction(String action, EntryData metaData) {
				//System.out.printf("progressFailedAction - %s %s\n", action, metaData);
			}
		};
	}

}
