/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.List;
import java.util.Vector;
import org.eclipse.cosmos.me.sdd.schema.ConditionalPropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.DisplayTextCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.PropertyValueListCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.StringCompare;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalPropertyConstraintCompare {
    public static Vector<ConditionalPropertyConstraintType> merge(List<ConditionalPropertyConstraintType> pcs, List<ConditionalPropertyConstraintType> pcs2) {
        Vector<ConditionalPropertyConstraintType> toRemove = new Vector<ConditionalPropertyConstraintType>();
        for (ConditionalPropertyConstraintType o1 : pcs) {
            for (ConditionalPropertyConstraintType o2 : pcs2) {
                if (toRemove.contains(o2) || !ConditionalPropertyConstraintCompare.equals(o1, o2)) continue;
                toRemove.add(o2);
                o1 = ConditionalPropertyConstraintCompare.merge(o1, o2);
            }
        }
        pcs2.removeAll(toRemove);
        Vector<ConditionalPropertyConstraintType> finals = new Vector<ConditionalPropertyConstraintType>();
        finals.addAll(pcs);
        finals.addAll(pcs2);
        return finals;
    }

    protected static ConditionalPropertyConstraintType merge(ConditionalPropertyConstraintType o1, ConditionalPropertyConstraintType o2) {
        ObjectFactory objectFactory = new ObjectFactory();
        ConditionalPropertyConstraintType pc = objectFactory.createConditionalPropertyConstraintType();
        pc.setDescription(DisplayTextCompare.merge(o1.getDescription(), o2.getDescription()));
        pc.setShortDescription(DisplayTextCompare.merge(o1.getShortDescription(), o2.getShortDescription()));
        pc.setListOfValues(o1.getListOfValues());
        pc.setPropertyName(o1.getPropertyName());
        pc.setValue(o1.getValue());
        return pc;
    }

    protected static boolean equals(ConditionalPropertyConstraintType pc, ConditionalPropertyConstraintType pc2) {
        if (!PropertyValueListCompare.equals(pc.getListOfValues(), pc2.getListOfValues())) {
            return false;
        }
        if (!StringCompare.equals(pc.getValue(), pc2.getValue())) {
            return false;
        }
        return StringCompare.equals(pc.getPropertyName(), pc2.getPropertyName());
    }
}

