/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.List;
import org.eclipse.cosmos.me.sdd.schema.ConditionType;
import org.eclipse.cosmos.me.sdd.schema.IdentityType;
import org.eclipse.cosmos.me.sdd.schema.InstallableUnitType;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.CompletionCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.ConditionCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.IdentityCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.LanguagesCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.RequiredBaseCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.RequirementsCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.ResourceCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.ResultingChangeCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.ResultingResourceCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.VariablesCompare;

public class InstallableUnitCompare {
    protected static InstallableUnitType merge(InstallableUnitType iu1, InstallableUnitType iu2) {
        if (!InstallableUnitCompare.equals(iu1, iu2)) {
            return null;
        }
        ObjectFactory objectFactory = new ObjectFactory();
        InstallableUnitType merged = objectFactory.createInstallableUnitType();
        merged.setId(iu1.getId());
        IdentityType i = IdentityCompare.merge(iu1.getIdentity(), iu2.getIdentity());
        if (i == null) {
            return null;
        }
        merged.setIdentity(i);
        merged.setVariables(VariablesCompare.merge(iu1.getVariables(), iu2.getVariables()));
        ConditionType c = ConditionCompare.merge(iu1.getCondition(), iu2.getCondition());
        if (c == null) {
            return null;
        }
        merged.setCondition(c);
        merged.setRequiredBase(RequiredBaseCompare.merge(iu1.getRequiredBase(), iu2.getRequiredBase()));
        merged.setRequirements(RequirementsCompare.merge(iu1.getRequirements(), iu2.getRequirements()));
        merged.setLanguages(LanguagesCompare.merge(iu1.getLanguages(), iu2.getLanguages()));
        merged.getCompletion().addAll(CompletionCompare.merge(iu1.getCompletion(), iu2.getCompletion()));
        merged.setArtifacts(iu1.getArtifacts());
        return merged;
    }

    private static boolean equals(InstallableUnitType unit1, InstallableUnitType unit2) {
        List r2;
        if (unit1.getResultingResource() == null && unit2.getResultingResource() != null) {
            return false;
        }
        if (unit1.getResultingResource() != null && unit2.getResultingResource() == null) {
            return false;
        }
        List r1 = unit1.getResultingResource();
        if (!ResultingResourceCompare.equals(r1, r2 = unit2.getResultingResource())) {
            return false;
        }
        if (unit1.getResultingChange() == null && unit2.getResultingChange() != null) {
            return false;
        }
        if (unit1.getResultingChange() != null && unit2.getResultingChange() == null) {
            return false;
        }
        r1 = unit1.getResultingChange();
        if (!ResultingChangeCompare.equals(r1, r2 = unit2.getResultingChange())) {
            return false;
        }
        return ResourceCompare.equals((ResourceType)unit1.getTargetResourceRef(), (ResourceType)unit2.getTargetResourceRef());
    }
}

