/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.PropertyCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.StringCompare;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceCompare {
    protected static Collection<ResourceType> merge(Collection<ResourceType> resources1, Collection<ResourceType> resources2) {
        Vector<ResourceType> resourcesToRemove = new Vector<ResourceType>();
        for (ResourceType resource1 : resources1) {
            for (ResourceType resource2 : resources2) {
                if (resourcesToRemove.contains(resource2) || !ResourceCompare.equals(resource1, resource2)) continue;
                resourcesToRemove.add(resource2);
                resource1.getHostedResource().addAll(ResourceCompare.merge(resource1.getHostedResource(), resource2.getHostedResource()));
            }
        }
        resources2.removeAll(resourcesToRemove);
        Vector<ResourceType> finalResources = new Vector<ResourceType>();
        finalResources.addAll(resources1);
        finalResources.addAll(resources2);
        return finalResources;
    }

    protected static boolean equals(ResourceType resource1, ResourceType resource2) {
        try {
            if (!StringCompare.equals(resource1.getType(), resource2.getType())) {
                return false;
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Required parameter \"Type\" missing from resource");
            return false;
        }
        if (resource1.getProperty() != null && resource2.getProperty() == null) {
            return false;
        }
        if (resource1.getProperty() == null && resource2.getProperty() != null) {
            return false;
        }
        if (resource1.getProperty() != null && resource2.getProperty() != null && !PropertyCompare.equals(resource1.getProperty(), resource2.getProperty())) {
            return false;
        }
        if (resource1.getName() != null && resource2.getName() == null) {
            return false;
        }
        if (resource1.getName() == null && resource2.getName() != null) {
            return false;
        }
        return resource1.getName() == null || resource2.getName() == null || StringCompare.equals(resource1.getName(), resource2.getName());
    }
}

