/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.List;
import java.util.Vector;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.schema.ResourcePropertyType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.DisplayTextCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.ResourceCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.StringCompare;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcePropertyCompare {
    protected static Vector<ResourcePropertyType> merge(List<ResourcePropertyType> params, List<ResourcePropertyType> params2) {
        Vector<ResourcePropertyType> toRemove = new Vector<ResourcePropertyType>();
        for (ResourcePropertyType o1 : params) {
            for (ResourcePropertyType o2 : params2) {
                if (toRemove.contains(o2) || !ResourcePropertyCompare.equals(o1, o2)) continue;
                toRemove.add(o2);
                o1 = ResourcePropertyCompare.merge(o1, o2);
            }
        }
        params2.removeAll(toRemove);
        Vector<ResourcePropertyType> finals = new Vector<ResourcePropertyType>();
        finals.addAll(params);
        finals.addAll(params2);
        return finals;
    }

    private static boolean equals(ResourcePropertyType o1, ResourcePropertyType o2) {
        if (o1.isSensitive() != o2.isSensitive()) {
            return false;
        }
        if (!ResourceCompare.equals((ResourceType)o1.getResourceRef(), (ResourceType)o1.getResourceRef())) {
            return false;
        }
        return StringCompare.equals(o1.getPropertyName(), o2.getPropertyName());
    }

    protected static ResourcePropertyType merge(ResourcePropertyType o1, ResourcePropertyType o2) {
        ObjectFactory objectFactory = new ObjectFactory();
        ResourcePropertyType merged = objectFactory.createResourcePropertyType();
        merged.setShortDescription(DisplayTextCompare.merge(o1.getShortDescription(), o2.getShortDescription()));
        merged.setDescription(DisplayTextCompare.merge(o1.getDescription(), o2.getDescription()));
        return merged;
    }
}

