/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.tooling.btg;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 *
 *
 */
public class BTGLogUtil {
    
   
    private static final String[] btgPackages = new String[] {
    	"org.eclipse.cosmos.me.sdd.schema",
        "org.eclipse.cosmos.me.sdd.tooling.btg",
        "org.eclipse.cosmos.me.sdd.tooling.btg.aggregator",
        "org.eclipse.cosmos.me.sdd.tooling.btg.sddreader",
        "org.eclipse.cosmos.me.common.sdd.validation"};

    public BTGLogUtil (){
    	
    }
    
    public static void initialize(String logFile)
    {

		String logDir = "";
        String logPropFile = "";
        String logFilePrefix = "sddbtg";
        String[] packages = new String[] {};
        boolean addingPackages = false;  // not currently used

        packages = btgPackages;
        
        if (addingPackages) {
        	logDir = "";
        }
        else 
        {
            boolean logFileFound = false;
            
            if (logFile != null)
            {
                File f = new File(logFile);
                if (f.exists())
                {
                    logPropFile = f.getAbsolutePath();
                    logFileFound = true;
                }
            }
            
            if (!logFileFound)
            {
                // Log to temp.
                logDir = null;
                
            }
        }
        
        /*
            Generate initial logging defaults from CI Logging component.
        */
        /* <LOGGING> */
//        Properties logConfig = LogUtil.getDefaultConfiguration(logFilePrefix, packages, logDir);

        /*set resource bundle names
        logConfig.setProperty("org.eclipse.cosmos.me.sdd.tooling.btg.log.resource.bundle",	"org.eclipse.cosmos.me.deployment.sdd.resources.tooling.btg.messages");
        logConfig.setProperty("org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.log.resource.bundle",	"org.eclipse.cosmos.me.deployment.sdd.tooling.btg.aggregator.res.messages");
        logConfig.setProperty("org.eclipse.cosmos.me.sdd.tooling.btg.sddreader.log.resource.bundle",	"org.eclipse.cosmos.me.deployment.sdd.tooling.btg.plugin.sddreader.res.messages");
        logConfig.setProperty("org.eclipse.cosmos.me.common.sdd.validation.log.resource.bundle",	"org.eclipse.cosmos.me.deployment.common.sdd.validation.res.messages");
        */
        if (addingPackages) {
            //LogUtil.getInstance().addPackages(packages, logConfig);
        }
        else {
        	/*
            Override logging defaults with our properties file
            */
            // TODO:  if we only do this on the first init, it means on later ones we can't override package-specific behaviors with the file
        	Exception loadError = null;
            try {
            	/* <LOGGING> */
//                loadConfig(logPropFile, logConfig);
            }
            catch (Exception e) {
                loadError = e;
            }
            
            /*
            Initialize logging
            */
            /* <LOGGING> */
//            LogUtil.getInstance().configure(logFilePrefix, packages, logConfig);

            Logger logger = Logger.getLogger("org.eclipse.cosmos.me.sdd.tooling.btg");

            // report any errors encountered up til now
            if (loadError != null) {
                logger.log(Level.WARNING, "ErrorLoadingLogProperties", logPropFile);
                logger.log(Level.FINE, loadError.getMessage(), loadError);
            }
        }
 


        // log the configuration properties we're using
        // logger.config("btglogger:\n" + LogUtil.listProperties("    ", logConfig));

        // log the Java system properties
        // logger.finer("System.getProperties():\n" + LogUtil.listProperties("    ", System.getProperties()));
    }
    
    /**
     * Get the full path name of the message log file for display to the user.
     * @return the full path name of the message log file.
     */
    public static String getMsgLogName() {
    	/* <LOGGING> */
//        String msgLogName = LogUtil.getMessageFileLocation();

    	/* <LOGGING> */
//        return LogUtil.getLogFileDisplayName(msgLogName);
    	return ("");
    }

}
