/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.examples.dr.drs.service.outputter;

import java.util.List;
import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Service;
import org.eclipse.cosmos.examples.dr.drs.service.outputter.Messages;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.BrokerNodeDecorator;

public class NodeDecorator
extends BrokerNodeDecorator {
    public String getDisplayName(Object node) {
        DataManager dm;
        if (node instanceof DataManager && (dm = (DataManager)node) != null) {
            String dmName = dm.getName();
            return dmName;
        }
        return Messages.getString("NodeDecorator.0");
    }

    public String getNodeClass(Object node) {
        DataManager dm;
        String nodeClass = "mdr";
        if (node instanceof DataManager && (dm = (DataManager)node) != null) {
            List services = dm.getServices();
            int x = 0;
            while (x < services.size()) {
                Service service = (Service)services.get(x);
                if (dm.getName() == null) {
                    nodeClass = "mdr";
                    break;
                }
                if (dm.getName().equalsIgnoreCase("Sample Repository with Query")) {
                    nodeClass = "mdrExample";
                    break;
                }
                if (dm.getName().equalsIgnoreCase("Resource Repository")) {
                    nodeClass = "smlRepository";
                    break;
                }
                if (service.getNamespace().equals("http://datamgr.stat.internal.dc.cosmos.eclipse.org")) {
                    nodeClass = "StatDataManager";
                } else {
                    if (service.getNamespace().equals("http://datamgr.logging.internal.dc.cosmos.eclipse.org")) {
                        nodeClass = "CBEDataManager";
                        break;
                    }
                    if (service.getNamespace().equals("http://cmdbf.org/schema/1-0-0/registration")) {
                        nodeClass = "mdrCMDBf";
                        break;
                    }
                    if (service.getNamespace().equals("http://cmdbf.org/schema/1-0-0/query")) {
                        nodeClass = "mdr";
                        break;
                    }
                }
                ++x;
            }
        }
        return nodeClass;
    }
}

