/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform;

import java.io.StringWriter;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IRootElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IAlternateInstanceId;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IInstanceResponse;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegistrationServiceOutputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IResponse;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.ITransformerHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractOutputStreamHandler
extends DefaultHandler
implements ITransformerHandler {
    private IResponse response;
    private String currentElementData;
    private IInstanceId currentInstanceId;
    private IInstanceResponse currentInstanceResponse;
    private IAlternateInstanceId currentAlternateInstanceId;
    private IRegistrationServiceOutputArtifactFactory artifactFactory;

    public AbstractOutputStreamHandler(IRegistrationServiceOutputArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (!"http://cmdbf.org/schema/1-0-0/datamodel".equals(uri)) {
            return;
        }
        if (this.getResponseElementName().equals(localName)) {
            this.response = this.createResponse();
        } else if ("instanceResponse".equals(localName)) {
            this.currentInstanceResponse = this.getArtifactFactory().createInstanceResponse();
            this.response.addInstanceResponse(this.currentInstanceResponse);
        } else if ("accepted".equals(localName)) {
            this.currentInstanceResponse.setAccepted(this.getArtifactFactory().createAccepted());
        } else if ("declined".equals(localName)) {
            this.currentInstanceResponse.setDeclined(this.getArtifactFactory().createDeclined());
        } else if ("instanceId".equals(localName)) {
            this.currentInstanceId = this.getArtifactFactory().createInstanceId();
        } else if ("alternateInstanceId".equals(localName)) {
            this.currentAlternateInstanceId = this.getArtifactFactory().createAlternateInstanceId();
        }
    }

    protected IResponse createResponse() {
        return this.getArtifactFactory().createResponse();
    }

    protected abstract String getResponseElementName();

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (!"http://cmdbf.org/schema/1-0-0/datamodel".equals(uri)) {
            return;
        }
        if ("mdrId".equals(localName)) {
            if (this.currentInstanceId != null) {
                this.currentInstanceId.setMdrId(this.currentElementData);
            } else if (this.currentAlternateInstanceId != null) {
                this.currentAlternateInstanceId.setMdrId(this.currentElementData);
            }
            this.currentElementData = null;
        } else if ("localId".equals(localName)) {
            if (this.currentInstanceId != null) {
                this.currentInstanceId.setLocalId(this.currentElementData);
            } else if (this.currentAlternateInstanceId != null) {
                this.currentAlternateInstanceId.setLocalId(this.currentElementData);
            }
            this.currentElementData = null;
        } else if ("instanceId".equals(localName)) {
            this.currentInstanceResponse.setInstanceId(this.currentInstanceId);
            this.currentInstanceId = null;
        } else if ("alternateInstanceId".equals(localName)) {
            this.currentInstanceResponse.getAccepted().addAlternateInstanceId(this.currentAlternateInstanceId);
            this.currentAlternateInstanceId = null;
        } else if ("reason".equals(localName)) {
            this.currentInstanceResponse.getDeclined().addReason(this.currentElementData);
            this.currentElementData = null;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tempData = new String(ch, start, length).trim();
        if (this.currentElementData == null) {
            this.currentElementData = tempData;
        } else {
            StringWriter tempWriter = new StringWriter();
            tempWriter.write(tempData);
            this.currentElementData = String.valueOf(this.currentElementData) + tempWriter.toString();
        }
    }

    public IResponse getResponse() {
        return this.response;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public IRootElement getResult() {
        return this.getResponse();
    }

    protected IRegistrationServiceOutputArtifactFactory getArtifactFactory() {
        if (this.artifactFactory == null) {
            this.artifactFactory = this.createArtifactFactory();
        }
        return this.artifactFactory;
    }

    protected abstract IRegistrationServiceOutputArtifactFactory createArtifactFactory();
}

