/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dr.internal.web.ui;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.cosmos.dr.internal.web.ui.ILauncher;
import org.eclipse.cosmos.dr.internal.web.ui.Messages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jst.ws.axis2.core.context.Axis2EmitterContext;
import org.eclipse.jst.ws.axis2.core.plugin.WebServiceAxis2CorePlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class WebViewerActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.cosmos.dr.web.ui";
    public static final String HOST_PREFERENCE = "COSMOS.UI.host";
    public static final String PORT_PREFERENCE = "COSMOS.UI.port";
    public static final String DOJOPATH_PREFERENCE = "COSMOS.UI.dojopath";
    public static final String DOJOBASEPATH_PREFERENCE = "COSMOS.UI.dojopbaseath";
    private static WebViewerActivator plugin;
    protected Bundle viewerBundle;
    protected ILauncher launcher;
    protected String axis2Location = "";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static WebViewerActivator getDefault() {
        return plugin;
    }

    public String getHostPreference() {
        return this.getPreferenceStore().getString(HOST_PREFERENCE);
    }

    public String getPortPreference() {
        return this.getPreferenceStore().getString(PORT_PREFERENCE);
    }

    public String getDojoPathPreference() {
        return this.getPreferenceStore().getString(DOJOPATH_PREFERENCE);
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        return new Status(4, PLUGIN_ID, 0, msg, (Throwable)e);
    }

    public String getDefaultHostPreference() {
        String defaultStr = this.getPreferenceStore().getDefaultString(HOST_PREFERENCE);
        return defaultStr;
    }

    public String getDefaultPortPreference() {
        String defaultStr = this.getPreferenceStore().getDefaultString(PORT_PREFERENCE);
        return defaultStr;
    }

    public String getDefaultDojoPathPreference() {
        String defaultStr = this.getPreferenceStore().getDefaultString(DOJOPATH_PREFERENCE);
        return defaultStr;
    }

    public String getDefaultDojoBasePathPreference() {
        String defaultStr = this.getPreferenceStore().getDefaultString(DOJOBASEPATH_PREFERENCE);
        return defaultStr;
    }

    public String getDojoBasePathPreference() {
        return this.getPreferenceStore().getString(DOJOBASEPATH_PREFERENCE);
    }

    public void setHostPreference(String value) {
        this.getPreferenceStore().putValue(HOST_PREFERENCE, value);
    }

    public void setPortPreference(String value) {
        this.getPreferenceStore().putValue(PORT_PREFERENCE, value);
    }

    public void setDojoPathPreference(String value) {
        String basePath = "";
        int dojoBaseIdx = value.indexOf("/dojo/dojo");
        if (dojoBaseIdx > 0) {
            basePath = value.substring(0, dojoBaseIdx);
        }
        this.getPreferenceStore().putValue(DOJOPATH_PREFERENCE, value);
        this.getPreferenceStore().putValue(DOJOBASEPATH_PREFERENCE, basePath);
    }

    public void launchCOSMOSUI(String name, String queryService) {
        Axis2EmitterContext axis2context = WebServiceAxis2CorePlugin.getDefault().getAxisEmitterContext();
        String newAxis2Location = axis2context.getAxis2RuntimeLocation();
        if (newAxis2Location == null || "".equals(newAxis2Location)) {
            Status status = new Status(4, PLUGIN_ID, 0, Messages.getString("WebViewerActivator.8"), null);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("WebViewerActivator.9"), (String)Messages.getString("WebViewerActivator.10"), (IStatus)status);
            return;
        }
        if (!this.axis2Location.equals(newAxis2Location)) {
            this.axis2Location = newAxis2Location;
            System.setProperty("AXIS2_LIB", String.valueOf(this.axis2Location) + File.separator + "lib");
            Bundle viewPlugin = Platform.getBundle((String)"org.eclipse.cosmos.dr.web.ui.viewer");
            try {
                viewPlugin.update();
                viewPlugin.start();
            }
            catch (BundleException e) {
                this.getLog().log(WebViewerActivator.createErrorStatus(e.getLocalizedMessage(), (Exception)((Object)e)));
            }
        }
        if (this.launcher != null) {
            this.launcher.launchCOSMOSUI(name, queryService);
        }
    }

    public void setLauncher(ILauncher launcher) {
        this.launcher = launcher;
    }
}

