/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.client;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.ServiceClient;

/**
 * Superclass of query service client and registration service client.   
 *
 */
public abstract class CMDBfServiceClient {

	public final static String SECURITY_NAMESPACE = "http://www.eclipse.org/cosmos/security";

	protected EndpointReference serviceEPR = null;
	protected String username = null;
	protected String password = null;
	protected int soapVersion = 11;
	
	/**
	 * Constructor taking an EPR string as parameter
	 * @param epr Endpoint reference URL of web service 
	 */
	public CMDBfServiceClient(String epr) {
		serviceEPR = new EndpointReference(epr);
	}
	
	/**
	 * Constructor taking an EndpointReference object as parameter
	 * @param epr EndpointReference object representing the EPR of the web service
	 */
	public CMDBfServiceClient(EndpointReference epr) {
		serviceEPR = epr;
	}
	
	
	/**
	 * Sets the username
	 * @param username
	 */
	public void setUsername(String username) {
		this.username = username;
	}

	/**
	 * Sets the password
	 * @param password
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * Gets the SOAP version
	 * @return
	 */
	public int getSoapVersion() {
		return soapVersion;
	}
	
	/**
	 * Sets the SOAP version
	 * @param soapVersion
	 */
	public void setSoapVersion(int soapVersion) {
		this.soapVersion = soapVersion;
	}
	

	/**
	 * construct and add a basic security header to the SOAP header
	 * 
	 * @param sender axis2 service client
	 * @param username username
	 * @param password password
	 */
	protected void addBasicSecurityHeader( ServiceClient sender, String username, String password) {

		OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace(SECURITY_NAMESPACE, "sec");
        
        OMElement header = factory.createOMElement("securityHeader", ns);
        header.addAttribute("mustUnderstand", "0", ns);
        
        OMElement elemUsername = factory.createOMElement("username", ns);
        elemUsername.setText( username );
        
        OMElement elemPswd = factory.createOMElement("password", ns);
        elemPswd.setText( password );
        
        header.addChild( elemUsername );
        header.addChild( elemPswd );
        
		sender.addHeader(header);
	}

}
