/*******************************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     CA - initial API and implementation
 *     IBM - provisional API change
 *******************************************************************************/
package org.eclipse.cosmos.dc.internal.cmdbf.services.metadata.transform.input.artifacts;

import java.io.StringWriter;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.ServiceMetadataConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IContentSelectorSupport;


public class ContentSelectorSupport implements IContentSelectorSupport 
{
	private boolean recordTypeSelector;
	private boolean propertySelector;

	
	/**
	 * set the recordTypeSelector 
	 * 
	 * @param recordTypeSelector
	 */
	public void setRecordTypeSelector(boolean recordTypeSelector){
		this.recordTypeSelector = recordTypeSelector;
	}
		
	/**
	 * Retrieve the recordTypeSelector
	 * 
	 * @return recordTypeSelector
	 */
	public boolean isRecordTypeSelector(){
		return recordTypeSelector;
	}

	
	/**
	 * set the propertySelector
	 * 
	 * @param propertySelector
	 */
	public void setPropertySelector(boolean propertySelector){
		this.propertySelector = propertySelector;
	}
		
	/**
	 * Retrieve the propertySelector
	 * 
	 * @return Boolean propertySelector
	 */
	public boolean isPropertySelector(){
		return propertySelector;
	}

	
	public void toXML(StringWriter writer, int indent) 
	{
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.tagFor(false, null, ServiceMetadataConstants.CONTENTSELECTORSUPPORT_ELEMENT, false));
		
		writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
		CMDBfServicesUtil.writeAttribute(writer, ServiceMetadataConstants.RECORDTYPESELECTOR_ATTRIBUTE, String.valueOf(recordTypeSelector));
		
		writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
		CMDBfServicesUtil.writeAttribute(writer, ServiceMetadataConstants.PROPERTYSELECTOR_ATTRIBUTE, String.valueOf(propertySelector));
		
		writer.write(ICMDBfServicesConstants.FORWARD_SLASH+ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET+ICMDBfServicesConstants.nl);
	}


	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final ContentSelectorSupport other = (ContentSelectorSupport) obj;
		
		return 	recordTypeSelector == other.recordTypeSelector &&
				propertySelector == other.propertySelector;	
	}
	
}
