/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.util.ArrayList;
import java.util.Iterator;

public class JSONArray extends ArrayList<Object>{

	/**
	 * 
	 */
	private static final long serialVersionUID = -4297098047645036723L;
	
	@Override
	public String toString() {
		Iterator<Object> keys = iterator();
		StringBuffer sb = new StringBuffer();
		sb.append("[");
		int x = 0;
		while (keys.hasNext()){
			if (x > 0)
				sb.append(",");
			Object value = keys.next();
			if (value instanceof String)
				sb.append("\""+removeTabAndReturnChar((String)value)+"\"");
			else 
				sb.append(value);
			x++;
		}
		sb.append("]");
		
		return sb.toString();
		
	}
	private String removeTabAndReturnChar(String value){
		String newVal = value.replaceAll("/", "\\\\/");
		newVal = newVal.replaceAll("\"", "\\\\\"");
		newVal = newVal.replaceAll("\'", "\\\\\'");
		newVal = newVal.replaceAll("\t", "\\\\t");
		newVal = newVal.replaceAll("\r", "\\\\r");
		return newVal.replaceAll("\n", "\\\\n");
		
	}
}
