/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RawToBinaryFormatStream;
import org.apache.derby.iapi.types.SQLBinary;

public class SQLBlob
extends SQLBinary {
    public SQLBlob() {
    }

    public SQLBlob(byte[] val) {
        super(val);
    }

    public SQLBlob(Blob val) {
        super(val);
    }

    public String getTypeName() {
        return "BLOB";
    }

    int getMaxMemoryUsage() {
        return Integer.MAX_VALUE;
    }

    public DataValueDescriptor getNewNull() {
        return new SQLBlob();
    }

    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        this.setValue(source);
        this.setWidth(desiredType.getMaximumWidth(), 0, true);
    }

    public void setWidth(int desiredWidth, int desiredScale, boolean errorOnTrunc) throws StandardException {
        if (this.isNull()) {
            return;
        }
        if (this.isLengthLess()) {
            return;
        }
        int sourceWidth = this.getLength();
        if (sourceWidth > desiredWidth) {
            if (errorOnTrunc) {
                throw StandardException.newException("22001", (Object)this.getTypeName(), (Object)"XXXX", (Object)String.valueOf(desiredWidth));
            }
            byte[] shrunkData = new byte[desiredWidth];
            System.arraycopy(this.getBytes(), 0, shrunkData, 0, desiredWidth);
            this.dataValue = shrunkData;
        }
    }

    public int getTypeFormatId() {
        return 443;
    }

    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException, StandardException {
        Blob blob = resultSet.getBlob(colNumber);
        if (blob == null) {
            this.setToNull();
        } else {
            this.setObject(blob);
        }
    }

    public int typePrecedence() {
        return 170;
    }

    public void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        if (this.isNull()) {
            ps.setBlob(position, (Blob)null);
            return;
        }
        ps.setBytes(position, this.getBytes());
    }

    final void setObject(Object theValue) throws StandardException {
        Blob vb = (Blob)theValue;
        try {
            long vbl = vb.length();
            if (vbl < 0L || vbl > Integer.MAX_VALUE) {
                throw this.outOfRange();
            }
            this.setValue(new RawToBinaryFormatStream(vb.getBinaryStream(), (int)vbl), (int)vbl);
        }
        catch (SQLException e) {
            throw this.dataTypeConversion("DAN-438-tmp");
        }
    }

    private final boolean isLengthLess() {
        return this.stream != null && this.streamValueLength < 0;
    }
}

