/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.RuleBasedCollator;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.ClobStreamHeaderGenerator;
import org.apache.derby.iapi.types.CollatorSQLClob;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.ReaderToUTF8Stream;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StreamHeaderGenerator;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.util.UTF8Util;

public class SQLClob
extends SQLVarchar {
    private static final int MAX_STREAM_HEADER_LENGTH = 5;
    private static final StreamHeaderGenerator TEN_FOUR_CLOB_HEADER_GENERATOR = new ClobStreamHeaderGenerator(true);
    private static final StreamHeaderGenerator TEN_FIVE_CLOB_HEADER_GENERATOR = new ClobStreamHeaderGenerator(false);
    private CharacterStreamDescriptor csd;
    private Boolean inSoftUpgradeMode = null;

    public String getTypeName() {
        return "CLOB";
    }

    public DataValueDescriptor getClone() {
        try {
            return new SQLClob(this.getString());
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
            return null;
        }
    }

    public DataValueDescriptor getNewNull() {
        return new SQLClob();
    }

    public StringDataValue getValue(RuleBasedCollator collatorForComparison) {
        if (collatorForComparison == null) {
            return this;
        }
        CollatorSQLClob s = new CollatorSQLClob(collatorForComparison);
        s.copyState(this);
        return s;
    }

    public int getTypeFormatId() {
        return 447;
    }

    public SQLClob() {
    }

    public SQLClob(String val) {
        super(val);
    }

    public SQLClob(Clob val) {
        super(val);
    }

    public int typePrecedence() {
        return 14;
    }

    public boolean getBoolean() throws StandardException {
        throw this.dataTypeConversion("boolean");
    }

    public byte getByte() throws StandardException {
        throw this.dataTypeConversion("byte");
    }

    public short getShort() throws StandardException {
        throw this.dataTypeConversion("short");
    }

    public int getInt() throws StandardException {
        throw this.dataTypeConversion("int");
    }

    public int getLength() throws StandardException {
        boolean repositionStream;
        if (this.stream == null) {
            return super.getLength();
        }
        boolean bl = repositionStream = this.csd != null;
        if (this.csd == null) {
            this.getStreamWithDescriptor();
        }
        if (this.csd.getCharLength() != 0L) {
            return (int)this.csd.getCharLength();
        }
        SanityManager.ASSERT(!this.csd.isPositionAware());
        long charLength = 0L;
        try {
            if (repositionStream) {
                this.rewindStream(this.csd.getDataOffset());
            }
            charLength = UTF8Util.skipUntilEOF(this.stream);
            this.rewindStream(0L);
        }
        catch (IOException ioe) {
            this.throwStreamingIOException(ioe);
        }
        this.csd = new CharacterStreamDescriptor.Builder().copyState(this.csd).charLength(charLength).curBytePos(0L).curCharPos(0L).build();
        return (int)charLength;
    }

    public long getLong() throws StandardException {
        throw this.dataTypeConversion("long");
    }

    public float getFloat() throws StandardException {
        throw this.dataTypeConversion("float");
    }

    public double getDouble() throws StandardException {
        throw this.dataTypeConversion("double");
    }

    public int typeToBigDecimal() throws StandardException {
        throw this.dataTypeConversion("java.math.BigDecimal");
    }

    public byte[] getBytes() throws StandardException {
        throw this.dataTypeConversion("byte[]");
    }

    public Date getDate(Calendar cal) throws StandardException {
        throw this.dataTypeConversion("java.sql.Date");
    }

    public CharacterStreamDescriptor getStreamWithDescriptor() throws StandardException {
        if (this.stream == null) {
            this.csd = null;
            return null;
        }
        if (this.csd != null) {
            if (this.stream instanceof Resetable) {
                try {
                    ((Resetable)((Object)this.stream)).resetStream();
                    InputStreamUtil.skipFully(this.stream, this.csd.getCurBytePos());
                }
                catch (IOException ioe) {
                    this.throwStreamingIOException(ioe);
                }
            } else {
                SanityManager.THROWASSERT("Unable to reset stream when fetched the second time: " + this.stream.getClass());
            }
        }
        if (this.csd == null) {
            try {
                byte[] header = new byte[5];
                int read = this.stream.read(header);
                SanityManager.ASSERT(read > 1, "Too few header bytes: " + read);
                HeaderInfo hdrInfo = this.investigateHeader(header, read);
                if (read > hdrInfo.headerLength()) {
                    read = hdrInfo.headerLength();
                    this.rewindStream(read);
                }
                this.csd = new CharacterStreamDescriptor.Builder().stream(this.stream).bufferable(false).positionAware(false).curCharPos(read == 0 ? 0L : 1L).curBytePos(read).dataOffset(hdrInfo.headerLength()).byteLength(hdrInfo.byteLength()).charLength(hdrInfo.charLength()).build();
            }
            catch (IOException ioe) {
                StandardException se;
                Throwable rootCause = ioe;
                while (rootCause.getCause() != null) {
                    rootCause = rootCause.getCause();
                }
                if (rootCause instanceof StandardException && (se = (StandardException)rootCause).getMessageId().equals("40XD0")) {
                    throw StandardException.newException("XJ073.S", ioe);
                }
                this.throwStreamingIOException(ioe);
            }
        }
        return this.csd;
    }

    public Time getTime(Calendar cal) throws StandardException {
        throw this.dataTypeConversion("java.sql.Time");
    }

    public Timestamp getTimestamp(Calendar cal) throws StandardException {
        throw this.dataTypeConversion("java.sql.Timestamp");
    }

    public final String getTraceString() throws StandardException {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.getStream() != null) {
            return this.getTypeName() + "(" + this.getStream().toString() + ")";
        }
        return this.getTypeName() + "(" + this.getLength() + ")";
    }

    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor sourceValue) throws StandardException {
        if (sourceValue instanceof SQLClob) {
            SQLClob clob = (SQLClob)sourceValue;
            if (clob.stream != null) {
                this.copyState(clob);
                return;
            }
        }
        super.normalize(desiredType, sourceValue);
    }

    public void setValue(Time theValue, Calendar cal) throws StandardException {
        this.throwLangSetMismatch("java.sql.Time");
    }

    public void setValue(Timestamp theValue, Calendar cal) throws StandardException {
        this.throwLangSetMismatch("java.sql.Timestamp");
    }

    public void setValue(Date theValue, Calendar cal) throws StandardException {
        this.throwLangSetMismatch("java.sql.Date");
    }

    public void setBigDecimal(Number bigDecimal) throws StandardException {
        this.throwLangSetMismatch("java.math.BigDecimal");
    }

    public final void setStream(InputStream stream) {
        super.setStream(stream);
        this.csd = null;
    }

    public final void restoreToNull() {
        this.csd = null;
        super.restoreToNull();
    }

    public void setValue(int theValue) throws StandardException {
        this.throwLangSetMismatch("int");
    }

    public void setValue(double theValue) throws StandardException {
        this.throwLangSetMismatch("double");
    }

    public void setValue(float theValue) throws StandardException {
        this.throwLangSetMismatch("float");
    }

    public void setValue(short theValue) throws StandardException {
        this.throwLangSetMismatch("short");
    }

    public void setValue(long theValue) throws StandardException {
        this.throwLangSetMismatch("long");
    }

    public void setValue(byte theValue) throws StandardException {
        this.throwLangSetMismatch("byte");
    }

    public void setValue(boolean theValue) throws StandardException {
        this.throwLangSetMismatch("boolean");
    }

    public void setValue(byte[] theValue) throws StandardException {
        this.throwLangSetMismatch("byte[]");
    }

    final void setObject(Object theValue) throws StandardException {
        Clob vc = (Clob)theValue;
        try {
            long vcl = vc.length();
            if (vcl < 0L || vcl > Integer.MAX_VALUE) {
                throw this.outOfRange();
            }
            if (vcl < 32768L) {
                this.setValue(vc.getSubString(1L, (int)vcl));
            } else {
                ReaderToUTF8Stream utfIn = new ReaderToUTF8Stream(vc.getCharacterStream(), (int)vcl, 0, "CLOB", this.getStreamHeaderGenerator());
                this.setValue(utfIn, (int)vcl);
            }
        }
        catch (SQLException e) {
            throw this.dataTypeConversion("DAN-438-tmp");
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeClobUTF(out);
    }

    public StreamHeaderGenerator getStreamHeaderGenerator() {
        if (this.inSoftUpgradeMode == null) {
            return new ClobStreamHeaderGenerator(this);
        }
        if (this.inSoftUpgradeMode == Boolean.TRUE) {
            return TEN_FOUR_CLOB_HEADER_GENERATOR;
        }
        return TEN_FIVE_CLOB_HEADER_GENERATOR;
    }

    public void setSoftUpgradeMode(Boolean inSoftUpgradeMode) {
        this.inSoftUpgradeMode = inSoftUpgradeMode;
    }

    private HeaderInfo investigateHeader(byte[] hdr, int bytesRead) throws IOException {
        int dataOffset = 5;
        int utfLen = -1;
        int strLen = -1;
        if (bytesRead < dataOffset || (hdr[2] & 0xF0) != 240) {
            dataOffset = 2;
        }
        if (dataOffset == 2) {
            utfLen = (hdr[0] & 0xFF) << 8 | hdr[1] & 0xFF;
            if (bytesRead < 5 && dataOffset + utfLen != bytesRead) {
                throw new IOException("Corrupted stream; headerLength=" + dataOffset + ", utfLen=" + utfLen + ", bytesRead=" + bytesRead);
            }
            if (utfLen > 0) {
                utfLen += dataOffset;
            }
        } else if (dataOffset == 5) {
            int hdrFormat = hdr[2] & 0xF;
            switch (hdrFormat) {
                case 0: {
                    strLen = (hdr[0] & 0xFF) << 24 | (hdr[1] & 0xFF) << 16 | (hdr[3] & 0xFF) << 8 | (hdr[4] & 0xFF) << 0;
                    break;
                }
                default: {
                    throw new IOException("Invalid header format identifier: " + hdrFormat + "(magic byte is 0x" + Integer.toHexString(hdr[2] & 0xFF) + ")");
                }
            }
        }
        SanityManager.ASSERT(utfLen > -1 || strLen > -1);
        return new HeaderInfo(dataOffset, dataOffset == 5 ? strLen : utfLen);
    }

    public void readExternal(ObjectInput in) throws IOException {
        HeaderInfo hdrInfo;
        if (this.csd != null) {
            int hdrLen = (int)this.csd.getDataOffset();
            int valueLength = hdrLen == 5 ? (int)this.csd.getCharLength() : (int)this.csd.getByteLength();
            hdrInfo = new HeaderInfo(hdrLen, valueLength);
            this.rewindStream(hdrLen);
        } else {
            byte[] header;
            int read;
            boolean markSet = this.stream.markSupported();
            if (markSet) {
                this.stream.mark(5);
            }
            SanityManager.ASSERT((read = in.read(header = new byte[5])) > 1, "Too few header bytes: " + read);
            hdrInfo = this.investigateHeader(header, read);
            if (read > hdrInfo.headerLength()) {
                if (markSet) {
                    this.stream.reset();
                    InputStreamUtil.skipFully(this.stream, hdrInfo.headerLength());
                } else if (this.stream instanceof Resetable) {
                    this.rewindStream(hdrInfo.headerLength());
                }
            }
        }
        int byteLength = 0;
        if (hdrInfo.byteLength() != 0) {
            byteLength = hdrInfo.byteLength() - hdrInfo.headerLength();
        }
        super.readExternal(in, byteLength, hdrInfo.charLength());
    }

    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        int prevPos = in.getPosition();
        byte[] header = new byte[5];
        int read = in.read(header);
        SanityManager.ASSERT(read > 1, "Too few header bytes: " + read);
        HeaderInfo hdrInfo = this.investigateHeader(header, read);
        if (read > hdrInfo.headerLength()) {
            in.setPosition(prevPos);
            super.readExternalFromArray(in);
        } else {
            super.readExternalClobFromArray(in, hdrInfo.charLength());
        }
    }

    private void rewindStream(long pos) throws IOException {
        try {
            ((Resetable)((Object)this.stream)).resetStream();
            InputStreamUtil.skipFully(this.stream, pos);
        }
        catch (StandardException se) {
            IOException ioe = new IOException(se.getMessage());
            ioe.initCause(se);
            throw ioe;
        }
    }

    private static class HeaderInfo {
        private final int valueLength;
        private final int headerLength;

        HeaderInfo(int headerLength, int valueLength) {
            this.headerLength = headerLength;
            this.valueLength = valueLength;
        }

        int headerLength() {
            return this.headerLength;
        }

        int charLength() {
            return this.isCharLength() ? this.valueLength : 0;
        }

        int byteLength() {
            return this.isCharLength() ? 0 : this.valueLength;
        }

        boolean isCharLength() {
            return this.headerLength == 5;
        }

        public String toString() {
            return "headerLength=" + this.headerLength + ", valueLength= " + this.valueLength + ", isCharLength=" + this.isCharLength();
        }
    }
}

