/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.File;

public class PathUtil {
    public static final char SEP = File.separatorChar;
    public static final String SEP_STR = String.valueOf(SEP);

    private PathUtil() {
    }

    private static void basicPathChecks(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path is null");
        }
        if (!path.equals(path.trim())) {
            throw new IllegalArgumentException("Path has not been trimmed: '" + path + "'");
        }
    }

    public static String getBaseName(String path) {
        PathUtil.basicPathChecks(path);
        int sepIndex = path.lastIndexOf(SEP);
        if (sepIndex != -1 && sepIndex != path.length() - 1) {
            return path.substring(sepIndex + 1);
        }
        return path;
    }

    public static String getParent(String path) {
        int sepIndex;
        PathUtil.basicPathChecks(path);
        if (path.equals(SEP_STR)) {
            return null;
        }
        if (path.length() > 0 && path.charAt(path.length() - 1) == SEP) {
            path = path.substring(0, path.length() - 1);
        }
        if ((sepIndex = path.lastIndexOf(SEP)) == 0) {
            return SEP_STR;
        }
        if (sepIndex > 0) {
            return path.substring(0, sepIndex);
        }
        return null;
    }

    public static String join(String parent, String base) {
        if (parent.charAt(parent.length() - 1) == SEP) {
            return parent + base;
        }
        return parent + SEP + base;
    }
}

