/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;

public class HasNodeVisitor
implements Visitor {
    private boolean hasNode;
    private Class nodeClass;
    private Class skipOverClass;

    public HasNodeVisitor(Class nodeClass) {
        this.nodeClass = nodeClass;
    }

    public HasNodeVisitor(Class nodeClass, Class skipOverClass) {
        this.nodeClass = nodeClass;
        this.skipOverClass = skipOverClass;
    }

    public Visitable visit(Visitable node) {
        if (this.nodeClass.isInstance(node)) {
            this.hasNode = true;
        }
        return node;
    }

    public boolean stopTraversal() {
        return this.hasNode;
    }

    public boolean skipChildren(Visitable node) {
        return this.skipOverClass == null ? false : this.skipOverClass.isInstance(node);
    }

    public boolean hasNode() {
        return this.hasNode;
    }

    public void reset() {
        this.hasNode = false;
    }
}

