/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Vector;
import org.apache.derby.iapi.error.SQLWarningFactory;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.impl.sql.execute.AggregatorInfo;
import org.apache.derby.impl.sql.execute.AggregatorInfoList;
import org.apache.derby.impl.sql.execute.GenericAggregator;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

abstract class GenericAggregateResultSet
extends NoPutResultSetImpl {
    protected GenericAggregator[] aggregates;
    protected GeneratedMethod rowAllocator;
    protected AggregatorInfoList aggInfoList;
    public NoPutResultSet source;
    protected NoPutResultSet originalSource;

    GenericAggregateResultSet(NoPutResultSet s, int aggregateItem, Activation a, GeneratedMethod ra, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = s;
        this.originalSource = s;
        this.rowAllocator = ra;
        this.aggInfoList = (AggregatorInfoList)a.getPreparedStatement().getSavedObject(aggregateItem);
        this.aggregates = this.getSortAggregators(this.aggInfoList, false, a.getLanguageConnectionContext(), s);
    }

    protected final GenericAggregator[] getSortAggregators(AggregatorInfoList list, boolean eliminateDistincts, LanguageConnectionContext lcc, NoPutResultSet inputResultSet) throws StandardException {
        Vector<GenericAggregator> tmpAggregators = new Vector<GenericAggregator>();
        ClassFactory cf = lcc.getLanguageConnectionFactory().getClassFactory();
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            AggregatorInfo aggInfo = (AggregatorInfo)list.elementAt(i);
            if (eliminateDistincts && aggInfo.isDistinct()) continue;
            tmpAggregators.addElement(new GenericAggregator(aggInfo, cf));
        }
        Object[] aggregators = new GenericAggregator[tmpAggregators.size()];
        tmpAggregators.copyInto(aggregators);
        return aggregators;
    }

    protected final ExecIndexRow finishAggregation(ExecIndexRow row) throws StandardException {
        int size = this.aggregates.length;
        if (row == null) {
            row = this.getExecutionFactory().getIndexableRow((ExecRow)this.rowAllocator.invoke(this.activation));
        }
        this.setCurrentRow(row);
        boolean eliminatedNulls = false;
        for (int i = 0; i < size; ++i) {
            GenericAggregator currAggregate = this.aggregates[i];
            if (!currAggregate.finish(row)) continue;
            eliminatedNulls = true;
        }
        if (eliminatedNulls) {
            this.addWarning(SQLWarningFactory.newSQLWarning("01003"));
        }
        return row;
    }

    public void finish() throws StandardException {
        this.source.finish();
        super.finish();
    }
}

