/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.net.SocketFactory;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.store.replication.net.ReplicationMessage;
import org.apache.derby.impl.store.replication.net.SlaveAddress;
import org.apache.derby.impl.store.replication.net.SocketConnection;

public class ReplicationMessageTransmit {
    private final int DEFAULT_MESSAGE_RESPONSE_TIMEOUT = 5000;
    private Thread msgReceiver = null;
    private final Object receiveSemaphore = new Object();
    private ReplicationMessage receivedMsg = null;
    private volatile boolean stopMessageReceiver = false;
    private final SlaveAddress slaveAddress;
    private SocketConnection socketConn;
    private String dbname;

    public ReplicationMessageTransmit(SlaveAddress slaveAddress) {
        this.slaveAddress = slaveAddress;
    }

    public void initConnection(int timeout, long synchOnInstant) throws PrivilegedActionException, IOException, StandardException, ClassNotFoundException {
        Socket s = null;
        final int timeout_ = timeout;
        s = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                SocketFactory sf = SocketFactory.getDefault();
                InetSocketAddress sockAddr = new InetSocketAddress(ReplicationMessageTransmit.this.slaveAddress.getHostAddress(), ReplicationMessageTransmit.this.slaveAddress.getPortNumber());
                Socket s_temp = sf.createSocket();
                s_temp.connect(sockAddr, timeout_);
                return s_temp;
            }
        });
        s.setKeepAlive(true);
        this.socketConn = new SocketConnection(s);
        this.startMessageReceiverThread(this.dbname);
        this.brokerConnection(synchOnInstant);
    }

    public void tearDown() throws IOException {
        this.stopMessageReceiver = true;
        this.msgReceiver = null;
        if (this.socketConn != null) {
            this.socketConn.tearDown();
            this.socketConn = null;
        }
    }

    public void sendMessage(ReplicationMessage message) throws IOException {
        this.checkSocketConnection();
        this.socketConn.writeMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ReplicationMessage sendMessageWaitForReply(ReplicationMessage message) throws IOException, StandardException {
        this.receivedMsg = null;
        this.checkSocketConnection();
        this.socketConn.writeMessage(message);
        Object object = this.receiveSemaphore;
        synchronized (object) {
            try {
                this.receiveSemaphore.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.receivedMsg == null) {
            throw StandardException.newException("XRE04.U.2", this.dbname);
        }
        return this.receivedMsg;
    }

    private void brokerConnection(long synchOnInstant) throws IOException, StandardException, ClassNotFoundException {
        ReplicationMessage initiatorMsg = new ReplicationMessage(0, new Long(1L));
        this.verifyMessageType(this.sendMessageWaitForReply(initiatorMsg), 11);
        initiatorMsg = new ReplicationMessage(1, new Long(synchOnInstant));
        this.verifyMessageType(this.sendMessageWaitForReply(initiatorMsg), 11);
    }

    private boolean verifyMessageType(ReplicationMessage message, int expectedType) throws StandardException {
        if (message.getType() == expectedType) {
            return true;
        }
        if (message.getType() == 12) {
            Object[] exception = (String[])message.getMessage();
            throw StandardException.newException(exception[exception.length - 1], exception);
        }
        throw StandardException.newException("XRE03");
    }

    private void checkSocketConnection() throws IOException {
        if (this.socketConn == null) {
            throw new IOException("R012");
        }
    }

    private void startMessageReceiverThread(String dbname) {
        this.msgReceiver = new MasterReceiverThread(dbname);
        this.msgReceiver.setDaemon(true);
        this.msgReceiver.start();
    }

    private class MasterReceiverThread
    extends Thread {
        private final ReplicationMessage pongMsg;

        MasterReceiverThread(String dbname) {
            super("derby.master.receiver-" + dbname);
            this.pongMsg = new ReplicationMessage(14, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!ReplicationMessageTransmit.this.stopMessageReceiver) {
                try {
                    ReplicationMessage message = this.readMessage();
                    switch (message.getType()) {
                        case 13: {
                            ReplicationMessageTransmit.this.sendMessage(this.pongMsg);
                            break;
                        }
                        case 11: 
                        case 12: {
                            Object object = ReplicationMessageTransmit.this.receiveSemaphore;
                            synchronized (object) {
                                ReplicationMessageTransmit.this.receivedMsg = message;
                                ReplicationMessageTransmit.this.receiveSemaphore.notify();
                                break;
                            }
                        }
                    }
                }
                catch (SocketTimeoutException ste) {
                }
                catch (ClassNotFoundException cnfe) {
                }
                catch (IOException ex) {
                    ReplicationMessageTransmit.this.stopMessageReceiver = true;
                    ReplicationMessageTransmit.this.msgReceiver = null;
                }
            }
        }

        private ReplicationMessage readMessage() throws ClassNotFoundException, IOException {
            ReplicationMessageTransmit.this.checkSocketConnection();
            return (ReplicationMessage)ReplicationMessageTransmit.this.socketConn.readMessage();
        }
    }
}

