/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Alias {
    public static void doProceduresAndFunctions(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT ALIAS, ALIASINFO, ALIASID, SCHEMAID, JAVACLASSNAME, SYSTEMALIAS FROM SYS.SYSALIASES WHERE ALIASTYPE='P'");
        DB_Alias.generateDDL(rs, 'P');
        rs = stmt.executeQuery("SELECT ALIAS, ALIASINFO, ALIASID, SCHEMAID, JAVACLASSNAME, SYSTEMALIAS FROM SYS.SYSALIASES WHERE ALIASTYPE='F'");
        DB_Alias.generateDDL(rs, 'F');
        rs.close();
        stmt.close();
    }

    private static void generateDDL(ResultSet rs, char aliasType) throws SQLException {
        boolean firstTime = true;
        while (rs.next()) {
            String procSchema;
            if (rs.getBoolean(6) || dblook.isIgnorableSchema(procSchema = dblook.lookupSchemaId(rs.getString(4)))) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage(aliasType == 'P' ? "DBLOOK_StoredProcHeader" : "DBLOOK_FunctionHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String aliasName = rs.getString(1);
            String fullName = dblook.addQuotes(dblook.expandDoubleQuotes(aliasName));
            fullName = procSchema + "." + fullName;
            String creationString = DB_Alias.createProcOrFuncString(fullName, rs, aliasType);
            Logs.writeToNewDDL(creationString);
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
    }

    private static String createProcOrFuncString(String aliasName, ResultSet aliasInfo, char aliasType) throws SQLException {
        StringBuffer alias = new StringBuffer("CREATE ");
        if (aliasType == 'P') {
            alias.append("PROCEDURE ");
        } else if (aliasType == 'F') {
            alias.append("FUNCTION ");
        }
        alias.append(aliasName);
        alias.append(" ");
        String params = aliasInfo.getString(2);
        alias.append(params.substring(params.indexOf("("), params.length()));
        alias.append(" ");
        alias.append("EXTERNAL NAME '");
        alias.append(aliasInfo.getString(5));
        alias.append(".");
        alias.append(params.substring(0, params.indexOf("(")));
        alias.append("' ");
        return alias.toString();
    }

    public static void doSynonyms(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT ALIAS, SCHEMAID, ALIASINFO, SYSTEMALIAS FROM SYS.SYSALIASES A WHERE ALIASTYPE='S'");
        boolean firstTime = true;
        while (rs.next()) {
            String aliasSchema;
            if (rs.getBoolean(4) || dblook.isIgnorableSchema(aliasSchema = dblook.lookupSchemaId(rs.getString(2)))) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_SynonymHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String aliasName = rs.getString(1);
            String aliasFullName = dblook.addQuotes(dblook.expandDoubleQuotes(aliasName));
            aliasFullName = aliasSchema + "." + aliasFullName;
            Logs.writeToNewDDL("CREATE SYNONYM " + aliasFullName + " FOR " + rs.getString(3));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
        rs.close();
        stmt.close();
    }
}

