/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.tools;

import java.io.BufferedReader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.dblook.DB_Alias;
import org.apache.derby.impl.tools.dblook.DB_Check;
import org.apache.derby.impl.tools.dblook.DB_GrantRevoke;
import org.apache.derby.impl.tools.dblook.DB_Index;
import org.apache.derby.impl.tools.dblook.DB_Jar;
import org.apache.derby.impl.tools.dblook.DB_Key;
import org.apache.derby.impl.tools.dblook.DB_Roles;
import org.apache.derby.impl.tools.dblook.DB_Schema;
import org.apache.derby.impl.tools.dblook.DB_Table;
import org.apache.derby.impl.tools.dblook.DB_Trigger;
import org.apache.derby.impl.tools.dblook.DB_View;
import org.apache.derby.impl.tools.dblook.Logs;

public final class dblook {
    private static final int DB2_MAX_NUMBER_OF_TABLES = 30;
    private Connection conn;
    private static PreparedStatement getColNameFromNumberQuery;
    private static HashMap schemaMap;
    private static HashMap tableIdToNameMap;
    private static String sourceDBUrl;
    private static String ddlFileName;
    private static String stmtDelimiter;
    private static boolean appendLogs;
    private static ArrayList tableList;
    private static String schemaParam;
    private static String targetSchema;
    private static boolean skipViews;
    private static boolean verbose;
    private static String sourceDBName;
    private static String lookLogName;
    private static LocalizedResource langUtil;
    private static boolean sqlAuthorization;
    private static final String[] ignorableSchemaNames;

    public static void main(String[] args) {
        try {
            new dblook(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public dblook(String[] args) throws Exception {
        langUtil = LocalizedResource.getInstance();
        this.initState();
        if (!this.parseArgs(args)) {
            System.out.println(dblook.lookupMessage("DBLOOK_Usage"));
            return;
        }
        this.showVariables();
        if (!this.loadDriver()) {
            return;
        }
        schemaMap = new HashMap();
        tableIdToNameMap = new HashMap();
        this.go();
    }

    private void initState() {
        sourceDBUrl = null;
        ddlFileName = null;
        stmtDelimiter = null;
        appendLogs = false;
        tableList = null;
        targetSchema = null;
        schemaParam = null;
        skipViews = false;
        verbose = false;
        sourceDBName = null;
    }

    private boolean parseArgs(String[] args) {
        if (args.length < 2) {
            return false;
        }
        int st = 0;
        for (int i = 0; i < args.length; ++i) {
            st = this.loadParam(args, i);
            if (st == -1) {
                return false;
            }
            i = st;
        }
        if (sourceDBUrl == null) {
            return false;
        }
        boolean okay = Logs.initLogs(lookLogName, ddlFileName, appendLogs, verbose, stmtDelimiter == null ? ";" : stmtDelimiter);
        sourceDBName = this.extractDBNameFromUrl(sourceDBUrl);
        targetSchema = schemaParam != null && schemaParam.length() > 0 && schemaParam.charAt(0) != '\"' ? dblook.addQuotes(dblook.expandDoubleQuotes(schemaParam.toUpperCase(Locale.ENGLISH))) : dblook.addQuotes(dblook.expandDoubleQuotes(dblook.stripQuotes(schemaParam)));
        return okay;
    }

    private int loadParam(String[] args, int start) {
        if (args[start].length() == 0 || args[start].charAt(0) != '-') {
            return start;
        }
        boolean haveVal = args.length > start + 1;
        switch (args[start].charAt(1)) {
            case 'd': {
                if (!haveVal) {
                    return -1;
                }
                if (args[start].length() == 2) {
                    sourceDBUrl = dblook.stripQuotes(args[++start]);
                    return start;
                }
                return -1;
            }
            case 'z': {
                if (!haveVal) {
                    return -1;
                }
                if (args[start].length() == 2) {
                    schemaParam = args[++start];
                    return start;
                }
                return -1;
            }
            case 't': {
                if (!haveVal) {
                    return -1;
                }
                if (args[start].equals("-td")) {
                    stmtDelimiter = args[++start];
                    return start;
                }
                if (args[start].equals("-t")) {
                    return this.extractTableNamesFromList(args, start + 1);
                }
                return -1;
            }
            case 'o': {
                if (!haveVal) {
                    return -1;
                }
                if (args[start].length() == 2 && args[start + 1].length() > 0) {
                    ddlFileName = args[++start];
                    return start;
                }
                return -1;
            }
            case 'a': {
                if (args[start].equals("-append")) {
                    appendLogs = true;
                    return start;
                }
                return -1;
            }
            case 'n': {
                if (args[start].equals("-noview")) {
                    skipViews = true;
                    return start;
                }
                return -1;
            }
            case 'v': {
                if (args[start].equals("-verbose")) {
                    verbose = true;
                    return start;
                }
                return -1;
            }
        }
        return -1;
    }

    private boolean loadDriver() {
        String derbyDriver = System.getProperty("driver");
        if (derbyDriver == null) {
            derbyDriver = sourceDBUrl.indexOf(":net://") != -1 ? "com.ibm.db2.jcc.DB2Driver" : (sourceDBUrl.startsWith("jdbc:derby://") ? "org.apache.derby.jdbc.ClientDriver" : "org.apache.derby.jdbc.EmbeddedDriver");
        }
        try {
            Class.forName(derbyDriver).newInstance();
        }
        catch (Exception e) {
            Logs.debug(e);
            return false;
        }
        return true;
    }

    private String extractDBNameFromUrl(String dbUrl) {
        if (dbUrl == null) {
            return "";
        }
        int start = dbUrl.indexOf("jdbc:derby:");
        if (start == -1) {
            return "";
        }
        start = dbUrl.indexOf("://");
        start = start == -1 ? dbUrl.indexOf("derby:") + 6 : dbUrl.indexOf("/", start + 3) + 1;
        int stop = -1;
        if (dbUrl.charAt(start) == '\"') {
            stop = dbUrl.indexOf("\"", ++start);
        } else {
            stop = dbUrl.indexOf(":", start);
            if (stop != -1 && (dbUrl.charAt(stop + 1) == '/' || dbUrl.charAt(stop + 1) == '\\')) {
                stop = dbUrl.indexOf(":", stop + 2);
            }
            int stop2 = dbUrl.length();
            if (stop == -1) {
                stop = dbUrl.indexOf(";", start);
            } else {
                stop2 = dbUrl.indexOf(";", start);
            }
            int n = stop = stop <= stop2 ? stop : stop2;
        }
        if (stop == -1) {
            stop = dbUrl.length();
        }
        return dbUrl.substring(start, stop);
    }

    private int extractTableNamesFromList(String[] args, int start) {
        int argIndex = start;
        int count = 0;
        tableList = new ArrayList();
        while (argIndex < args.length && (args[argIndex].length() <= 0 || args[argIndex].charAt(0) != '-') && ++count <= 30) {
            if (args[argIndex].length() > 0 && args[argIndex].charAt(0) == '\"') {
                tableList.add(dblook.addQuotes(dblook.expandDoubleQuotes(dblook.stripQuotes(args[argIndex++]))));
                continue;
            }
            tableList.add(dblook.addQuotes(dblook.expandDoubleQuotes(args[argIndex++].toUpperCase(Locale.ENGLISH))));
        }
        if (tableList.size() == 0) {
            tableList = null;
        }
        return argIndex - 1;
    }

    private void showVariables() {
        if (ddlFileName != null) {
            Logs.reportString("============================\n");
            Logs.reportMessage("DBLOOK_FileCreation");
            if (verbose) {
                dblook.writeVerboseOutput("DBLOOK_OutputLocation", ddlFileName);
            }
        }
        Logs.reportMessage("DBLOOK_Timestamp", new Timestamp(System.currentTimeMillis()).toString());
        Logs.reportMessage("DBLOOK_DBName", sourceDBName);
        Logs.reportMessage("DBLOOK_DBUrl", sourceDBUrl);
        if (tableList != null) {
            Logs.reportMessage("DBLOOK_TargetTables");
        }
        if (schemaParam != null) {
            Logs.reportMessage("DBLOOK_TargetSchema", dblook.stripQuotes(schemaParam));
        }
        Logs.reportString("appendLogs: " + appendLogs + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void go() throws Exception {
        try {
            this.conn = DriverManager.getConnection(sourceDBUrl);
            this.prepForDump();
            DB_Schema.doSchemas(this.conn, tableList != null && targetSchema == null);
            if (tableList == null) {
                DB_Jar.doJars(sourceDBName, this.conn);
                DB_Alias.doProceduresAndFunctions(this.conn);
            }
            DB_Table.doTables(this.conn, tableIdToNameMap);
            DB_Index.doIndexes(this.conn);
            DB_Alias.doSynonyms(this.conn);
            DB_Key.doKeys(this.conn);
            DB_Check.doChecks(this.conn);
            if (!skipViews) {
                DB_View.doViews(this.conn);
            }
            DB_Trigger.doTriggers(this.conn);
            DB_Roles.doRoles(this.conn);
            DB_GrantRevoke.doAuthorizations(this.conn);
            if (getColNameFromNumberQuery != null) {
                getColNameFromNumberQuery.close();
            }
            Logs.cleanup();
        }
        catch (SQLException sqlE) {
            Logs.debug(sqlE);
            Logs.debug(Logs.unRollExceptions(sqlE), (String)null);
            Logs.cleanup();
            return;
        }
        catch (Exception e) {
            Logs.debug(e);
            Logs.cleanup();
            return;
        }
        finally {
            if (this.conn != null) {
                this.conn.commit();
                this.conn.close();
            }
        }
    }

    private void prepForDump() throws Exception {
        String sqlAuth;
        this.conn.setAutoCommit(false);
        Statement stmt = this.conn.createStatement();
        stmt.executeUpdate("SET SCHEMA SYS");
        getColNameFromNumberQuery = this.conn.prepareStatement("SELECT COLUMNNAME FROM SYS.SYSCOLUMNS WHERE REFERENCEID = ? AND COLUMNNUMBER = ?");
        ResultSet rs = stmt.executeQuery("SELECT T.TABLEID, T.TABLENAME, S.SCHEMANAME FROM SYS.SYSTABLES T, SYS.SYSSCHEMAS S WHERE T.TABLETYPE = 'T' AND T.SCHEMAID = S.SCHEMAID");
        while (rs.next()) {
            String tableName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(2)));
            String schemaName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(3)));
            tableIdToNameMap.put(rs.getString(1), schemaName + "." + tableName);
        }
        rs = stmt.executeQuery("SELECT SCHEMAID, SCHEMANAME FROM SYS.SYSSCHEMAS");
        while (rs.next()) {
            schemaMap.put(rs.getString(1), dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(2))));
        }
        rs = stmt.executeQuery("VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.sqlAuthorization')");
        if (rs.next() && Boolean.valueOf(sqlAuth = rs.getString(1)).booleanValue()) {
            sqlAuthorization = true;
        }
        stmt.close();
    }

    public static String getColumnListFromDescription(String tableId, String description) throws SQLException {
        StringBuffer sb = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(description.substring(description.indexOf("(") + 1, description.lastIndexOf(")")), " ,", true);
        boolean firstCol = true;
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken().trim();
            if (tok.equals("")) continue;
            if (tok.equals(",")) {
                firstCol = false;
                continue;
            }
            try {
                String colName = dblook.getColNameFromNumber(tableId, Integer.valueOf(tok));
                if (!firstCol) {
                    sb.append(", ");
                }
                sb.append(colName);
            }
            catch (NumberFormatException e) {
                tok = tok.toUpperCase();
                if (tok.equals("DESC") || tok.equals("ASC")) {
                    sb.append(" " + tok);
                    continue;
                }
                Logs.debug("INTERNAL ERROR: read a non-number (" + tok + ") when a column number was expected:\n" + description, (String)null);
            }
        }
        return sb.toString();
    }

    public static String getColNameFromNumber(String tableId, int colNum) throws SQLException {
        getColNameFromNumberQuery.setString(1, tableId);
        getColNameFromNumberQuery.setInt(2, colNum);
        ResultSet rs = getColNameFromNumberQuery.executeQuery();
        if (!rs.next()) {
            Logs.debug("INTERNAL ERROR: Failed column number lookup for table " + dblook.lookupTableId(tableId) + ", column " + colNum, (String)null);
            rs.close();
            return "";
        }
        String colName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(1)));
        rs.close();
        return colName;
    }

    public static String addQuotes(String name) {
        if (name == null) {
            return null;
        }
        return "\"" + name + "\"";
    }

    public static String addSingleQuotes(String name) {
        if (name == null) {
            return null;
        }
        return "'" + name + "'";
    }

    public static String stripQuotes(String quotedName) {
        if (quotedName == null) {
            return null;
        }
        if (!quotedName.startsWith("'") && !quotedName.startsWith("\"")) {
            return quotedName;
        }
        if (!quotedName.endsWith("'") && !quotedName.endsWith("\"")) {
            return quotedName;
        }
        return quotedName.substring(1, quotedName.length() - 1);
    }

    public static boolean isExcludedTable(String tableName) {
        if (tableName == null) {
            return true;
        }
        int dot = tableName.indexOf(".");
        if (dot != -1) {
            if (dblook.isIgnorableSchema(tableName.substring(0, dot))) {
                return true;
            }
            tableName = tableName.substring(dot + 1, tableName.length());
        }
        return tableList != null && !tableList.contains(tableName);
    }

    public static boolean isIgnorableSchema(String schemaName) {
        if (targetSchema != null && !schemaName.equals(targetSchema)) {
            return true;
        }
        schemaName = dblook.stripQuotes(schemaName);
        boolean ret = false;
        int i = ignorableSchemaNames.length - 1;
        while (i >= 0 && !(ret = ignorableSchemaNames[i--].equalsIgnoreCase(schemaName))) {
        }
        return ret;
    }

    public static boolean stringContainsTargetTable(String str) {
        if (str == null) {
            return false;
        }
        if (tableList == null) {
            return true;
        }
        int strLen = str.length();
        for (int i = 0; i < tableList.size(); ++i) {
            String tableName = (String)tableList.get(i);
            tableName = dblook.expandDoubleQuotes(dblook.stripQuotes(tableName));
            int nameLen = tableName.length();
            String strCopy = tableName.equals(tableName.toUpperCase(Locale.ENGLISH)) ? str.toUpperCase() : str;
            int pos = strCopy.indexOf(tableName);
            while (pos != -1) {
                if (!dblook.partOfWord(str, pos, nameLen, strLen)) {
                    if (pos >= 1 && strCopy.charAt(pos - 1) == '\"' && pos + nameLen < strCopy.length() && strCopy.charAt(pos + nameLen) == '\"') {
                        if (str.substring(pos, pos + nameLen).equals(tableName)) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                pos = str.indexOf(tableName, pos + nameLen);
            }
        }
        return false;
    }

    private static boolean partOfWord(String str, int pos, int nameLen, int strLen) {
        boolean somethingBefore = false;
        if (pos > 0) {
            char c = str.charAt(pos - 1);
            somethingBefore = c == '_' || Character.isLetterOrDigit(c);
        }
        boolean somethingAfter = false;
        if (pos + nameLen < strLen) {
            char c = str.charAt(pos + nameLen);
            somethingAfter = c == '_' || Character.isLetterOrDigit(c);
        }
        return somethingBefore || somethingAfter;
    }

    public static String expandDoubleQuotes(String name) {
        if (name == null || name.indexOf("\"") < 0) {
            return name;
        }
        char[] cA = name.toCharArray();
        char[] result = new char[2 * cA.length];
        int j = 0;
        for (int i = 0; i < cA.length; ++i) {
            if (cA[i] == '\"') {
                result[j++] = 34;
                result[j++] = 34;
                continue;
            }
            result[j++] = cA[i];
        }
        return new String(result, 0, j);
    }

    public static String lookupSchemaId(String schemaId) {
        return (String)schemaMap.get(schemaId);
    }

    public static String lookupTableId(String tableId) {
        return (String)tableIdToNameMap.get(tableId);
    }

    public static void writeVerboseOutput(String key, String value) {
        if (value == null) {
            System.err.println(dblook.lookupMessage(key));
        } else {
            System.err.println(dblook.lookupMessage(key, new String[]{value}));
        }
    }

    public static String lookupMessage(String key) {
        return dblook.lookupMessage(key, null);
    }

    public static String lookupMessage(String key, String[] vals) {
        String msg = "";
        if (vals == null) {
            msg = langUtil.getTextMessage(key);
        } else {
            switch (vals.length) {
                case 1: {
                    msg = langUtil.getTextMessage(key, vals[0]);
                    break;
                }
                case 2: {
                    msg = langUtil.getTextMessage(key, vals[0], vals[1]);
                    break;
                }
            }
        }
        return msg;
    }

    public static String removeNewlines(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer result = null;
        try {
            BufferedReader strVal = new BufferedReader(new StringReader(str));
            String txt = strVal.readLine();
            while (txt != null) {
                if (result == null) {
                    result = new StringBuffer(txt);
                } else {
                    result.append(" ");
                    result.append(txt);
                }
                txt = strVal.readLine();
            }
            return result.toString();
        }
        catch (Exception e) {
            return str;
        }
    }

    static {
        lookLogName = "dblook.log";
        ignorableSchemaNames = new String[]{"SYSIBM", "SYS", "SYSVISUAL", "SYSCAT", "SYSFUN", "SYSPROC", "SYSSTAT", "NULLID", "SYSCS_ADMIN", "SYSCS_DIAG", "SYSCS_UTIL", "SQLJ"};
    }
}

