/*******************************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     CA - initial API and implementation
 *     IBM - provisional API change
 *******************************************************************************/
package org.eclipse.cosmos.dc.internal.cmdbf.services.metadata.transform.input.artifacts;

import java.io.StringWriter;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.ServiceMetadataConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IRecordType;


public class RecordType implements IRecordType 
{
	private String localName = null;
	private String appliesTo = null;

	
	/**
	 * set the localName 
	 * 
	 * @param localName
	 */
	public void setLocalName(String localName){
		this.localName = localName;
	}
		
	/**
	 * Retrieve the localName
	 * 
	 * @return localName
	 */
	public String getLocalName(){
		return localName;
	}

	
	/**
	 * set the appliesTo 
	 * 
	 * @param appliesTo
	 */
	public void setAppliesTo(String appliesTo){
		this.appliesTo = appliesTo;
	}
		
	/**
	 * Retrieve the appliesTo
	 * 
	 * @return appliesTo
	 */
	public String getAppliesTo(){
		return appliesTo;
	}

	
	public void toXML(StringWriter writer, int indent) 
	{
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.tagFor(false, null, ServiceMetadataConstants.RECORDTYPE_ELEMENT, false));
		
		if ( localName != null || appliesTo != null ){
			if ( localName != null){
				writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
				CMDBfServicesUtil.writeAttribute(writer, ServiceMetadataConstants.LOCALNAME_ATTRIBUTE, localName );
			}
			
			if ( appliesTo != null){
				writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
				CMDBfServicesUtil.writeAttribute(writer, ServiceMetadataConstants.APPLIESTO_ATTRIBUTE, appliesTo );
			}
		}
		
		writer.write(ICMDBfServicesConstants.FORWARD_SLASH+ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET+ICMDBfServicesConstants.nl);
	}


	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final RecordType other = (RecordType) obj;
		if (localName == null) {
			if (other.localName != null)
				return false;
		} else if (!localName.equals(other.localName))
			return false;
		if (appliesTo == null) {
			if (other.appliesTo != null)
				return false;
		} else if (!appliesTo.equals(other.appliesTo))
			return false;

		return true;
	}
	
}
