/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.common.validation.plugin;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.cosmos.me.sdd.common.validation.ValidationRule;
import org.eclipse.cosmos.me.sdd.common.validation.XMLValidationError;
import org.eclipse.cosmos.me.sdd.common.validation.util.ValidatorUtils;
import org.eclipse.cosmos.me.sdd.resources.common.validation.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchematronValidationRule
implements ValidationRule {
    private File schematronRulesFile;

    public SchematronValidationRule(File schematronRulesFile) throws IOException, FileNotFoundException {
        this.schematronRulesFile = schematronRulesFile;
        if (!schematronRulesFile.exists()) {
            throw new FileNotFoundException(Messages.getString("SchematronValidationRule.0", schematronRulesFile.getName()));
        }
        if (!schematronRulesFile.canRead()) {
            throw new IOException(Messages.getString("SchematronValidationRule.2", schematronRulesFile.getName()));
        }
    }

    @Override
    public Collection<XMLValidationError> validate(InputStream xmlStream) {
        StreamResult errorReportResult;
        Vector<XMLValidationError> validationErrorList = new Vector<XMLValidationError>();
        try {
            FileInputStream schematronInputStream = new FileInputStream(ValidatorUtils.getTempFileFromSchematronText());
            Transformer compileSchematronTransformer = TransformerFactory.newInstance().newTransformer(new StreamSource(schematronInputStream));
            FileInputStream schematronRulesInputStream = new FileInputStream(this.schematronRulesFile);
            StreamResult schematronXslResult = new StreamResult(new ByteArrayOutputStream());
            compileSchematronTransformer.transform(new StreamSource(schematronRulesInputStream), schematronXslResult);
            ByteArrayInputStream xslInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)schematronXslResult.getOutputStream()).toByteArray());
            errorReportResult = new StreamResult(new ByteArrayOutputStream());
            Transformer schematronTransformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xslInputStream));
            schematronTransformer.transform(new StreamSource(xmlStream), errorReportResult);
        }
        catch (FileNotFoundException e) {
            String errorMsg = Messages.getString("SchematronValidationRule.4");
            XMLValidationError error = new XMLValidationError(errorMsg, this, e);
            validationErrorList.add(error);
            return validationErrorList;
        }
        catch (TransformerConfigurationException e) {
            String errorMsg = Messages.getString("SchematronValidationRule.5");
            XMLValidationError error = new XMLValidationError(errorMsg, this, e);
            validationErrorList.add(error);
            return validationErrorList;
        }
        catch (TransformerException e) {
            String errorMsg = Messages.getString("SchematronValidationRule.6");
            XMLValidationError error = new XMLValidationError(errorMsg, this, e);
            validationErrorList.add(error);
            return validationErrorList;
        }
        BufferedReader errorReport = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(((ByteArrayOutputStream)errorReportResult.getOutputStream()).toByteArray())));
        try {
            String errorReportLine = errorReport.readLine();
            while (errorReportLine != null) {
                XMLValidationError validationError = new XMLValidationError(errorReportLine, -1, -1, this, 2);
                validationErrorList.add(validationError);
                errorReportLine = errorReport.readLine();
            }
        }
        catch (IOException e) {
            String errorMsg = Messages.getString("SchematronValidationRule.7");
            XMLValidationError error = new XMLValidationError(errorMsg, this, e);
            validationErrorList.add(error);
            return validationErrorList;
        }
        return validationErrorList;
    }

    public File getSchematronRulesFile() {
        return this.schematronRulesFile;
    }
}

