/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts.interfaces;

import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

/**
 * Interface for project config objects used for building data manager projects
 * 
 * @author David Whiteman
 */
public interface IProjectConfig {

	public int QUERY_SERVICE = 0;
	public int REGISTRATION_SERVICE = 1;

	/**
	 * Answer the name of the package containing the generated code
	 * 
	 * @return
	 */
	public abstract String getPackageName();

	/**
	 * Set the name of the package containing the generated code
	 * 
	 * @param packageName
	 */
	public abstract void setPackageName(String packageName);
	
	/**
	 * Answer the name of the class generated by this config.  This is usually the MDR
	 * name with a suffix concatenated.
	 * 
	 * @return
	 */
	public abstract String getGeneratedClassName();

	/**
	 * Answer the name of the MDR.  This will be the basis of the generated class names.
	 * @return
	 */
	public abstract String getName();

	/**
	 * Set the name of the MDR.  This will be the basis of the generated class names.
	 * @param name
	 */
	public abstract void setName(String name);
	
	/**
	 * Set the project that will hold the generated code.
	 * 
	 * @param project
	 */
	public abstract void setProject(IProject project);

	/**
	 * Answer the text that is displayed in wizards to describe this
	 * kind of project.
	 * 
	 * @return
	 */
	public abstract String getProjectTypeName();

	/**
	 * Answer the source for non-constructor methods that should be generated.  This is
	 * a good hook for overriding in subclasses.
	 * 
	 * @return
	 */
	public abstract String getServiceSpecificSource() throws CoreException;

	/**
	 * Answer the parent class from which the data manager class derives.
	 * 
	 * @return
	 */
	public abstract String getParentClassName();

	/**
	 * Answer whether the config is for building a query service
	 * 
	 * @return
	 */
	public abstract boolean isQueryServiceConfig();
	
	/**
	 * Answer whether the config is for building a registration service
	 * 
	 * @return
	 */
	public abstract boolean isRegistrationServiceConfig();
	
	/**
	 * Answer the source for the generated class
	 * 
	 * @return
	 * @throws CoreException
	 */
	public abstract String getClassSource() throws CoreException;
	
	/**
	 * Answer the list of WSDLs that need to be available in the MDR project
	 * 
	 * @return
	 */
	public abstract List<String> getWsdlFilesToCopy();
	
	/**
	 * Generate additional support classes need for this service.
	 */
	public abstract void createSupportCode() throws CoreException;

}