/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.broker.provisional.datamodel;

import java.util.Iterator;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;

public class Service {
    private String namespace;
    private String endpointReference;
    private String name;
    private String description;

    public String getNamespace() {
        return this.namespace == null ? null : this.namespace.trim();
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getEndpointReference() {
        return this.endpointReference == null ? null : this.endpointReference.trim();
    }

    public void setEndpointReference(String endpointReference) {
        this.endpointReference = endpointReference;
    }

    public String getName() {
        return this.name == null ? null : this.name.trim();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OMElement toOM() {
        String desc = this.getDescription();
        String name = this.getName();
        String namespace = this.getNamespace();
        String endpoint = this.getEndpointReference();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://www.eclipse.org/cosmos/broker", "tns");
        OMElement servicexml = fac.createOMElement("service", omNs);
        OMElement namexml2 = fac.createOMElement("name", omNs, (OMContainer)servicexml);
        OMElement descxml2 = fac.createOMElement("description", omNs, (OMContainer)servicexml);
        OMElement namespacexml = fac.createOMElement("namespace", omNs, (OMContainer)servicexml);
        OMElement endpointxml = fac.createOMElement("endpoint", omNs, (OMContainer)servicexml);
        fac.createOMText((OMContainer)namexml2, name);
        fac.createOMText((OMContainer)descxml2, desc);
        fac.createOMText((OMContainer)namespacexml, namespace);
        fac.createOMText((OMContainer)endpointxml, endpoint);
        return servicexml;
    }

    public static Service getService(OMElement servicexml) {
        Service service = new Service();
        Iterator serviceIter = servicexml.getChildElements();
        while (serviceIter.hasNext()) {
            OMElement elem = (OMElement)serviceIter.next();
            if (elem.getLocalName().equals("namespace")) {
                service.setNamespace(elem.getText());
                continue;
            }
            if (elem.getLocalName().equals("name")) {
                service.setName(elem.getText());
                continue;
            }
            if (elem.getLocalName().equals("endpoint")) {
                service.setEndpointReference(elem.getText());
                continue;
            }
            if (!elem.getLocalName().equals("description")) continue;
            service.setDescription(elem.getText());
        }
        return service;
    }
}

