/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.reference;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ReferenceDescriptor;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceContext {
    private int lineNumber;
    private String filePath;
    private boolean isNilref;
    private String elementName;
    private String namespace;
    private NamespaceContext namespaceContext;
    private List<ReferenceDescriptor> referenceDescriptors;
    private String[] aliases;
    private int documentPosition;
    private int[] nodePath;

    public ReferenceContext(String filePath, int lineNumber) {
        this.filePath = filePath;
        this.lineNumber = lineNumber;
        this.isNilref = false;
        this.referenceDescriptors = new ArrayList<ReferenceDescriptor>();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public boolean isNilref() {
        return this.isNilref;
    }

    public void setNilref(boolean isNilref) {
        this.isNilref = isNilref;
    }

    public List<ReferenceDescriptor> getReferenceDescriptors() {
        return this.referenceDescriptors;
    }

    public void setReferenceDescriptors(List<ReferenceDescriptor> referenceDescriptors) {
        this.referenceDescriptors = referenceDescriptors;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void addReferenceScheme(ReferenceDescriptor ref) {
        this.referenceDescriptors.add(ref);
    }

    public NamespaceContext getNamespaceContext() {
        Node documentNode;
        if (this.namespaceContext == null && (documentNode = SMLValidatorUtil.findDocumentNode(this.getAliases(), this.getDocumentPosition())) != null && this.nodePath != null) {
            this.namespaceContext = SMLValidatorUtil.buildNamespaceContext(documentNode, this.nodePath);
        }
        return this.namespaceContext;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public int[] getNodePath() {
        return this.nodePath;
    }

    public void setNodePath(int[] nodePath) {
        this.nodePath = nodePath;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public int getDocumentPosition() {
        return this.documentPosition;
    }

    public void setDocumentPosition(int documentPosition) {
        this.documentPosition = documentPosition;
    }
}

