/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

public class FloatingPoint {
    public static final int IEEE_754_FLOATING_POINT = 72;

    private FloatingPoint() {
    }

    private static final int convertFromByteToInt(byte[] buffer, int offset) {
        return buffer[offset] << 24 | (buffer[offset + 1] & 0xFF) << 16 | (buffer[offset + 2] & 0xFF) << 8 | buffer[offset + 3] & 0xFF;
    }

    private static final long convertFromByteToLong(byte[] buffer, int offset) {
        return ((long)buffer[offset] & 0xFFL) << 56 | ((long)buffer[offset + 1] & 0xFFL) << 48 | ((long)buffer[offset + 2] & 0xFFL) << 40 | ((long)buffer[offset + 3] & 0xFFL) << 32 | ((long)buffer[offset + 4] & 0xFFL) << 24 | ((long)buffer[offset + 5] & 0xFFL) << 16 | ((long)buffer[offset + 6] & 0xFFL) << 8 | (long)buffer[offset + 7] & 0xFFL;
    }

    public static final float getFloat(byte[] buffer, int offset) {
        return Float.intBitsToFloat(FloatingPoint.convertFromByteToInt(buffer, offset));
    }

    public static final double getDouble(byte[] buffer, int offset) {
        return Double.longBitsToDouble(FloatingPoint.convertFromByteToLong(buffer, offset));
    }

    public static final void floatToIeee754Bytes(byte[] buffer, int offset, float f) {
        int intBits = Float.floatToIntBits(f);
        buffer[offset] = (byte)(intBits >>> 24 & 0xFF);
        buffer[offset + 1] = (byte)(intBits >>> 16 & 0xFF);
        buffer[offset + 2] = (byte)(intBits >>> 8 & 0xFF);
        buffer[offset + 3] = (byte)(intBits & 0xFF);
    }

    public static final void doubleToIeee754Bytes(byte[] buffer, int offset, double d) {
        long longBits = Double.doubleToLongBits(d);
        buffer[offset] = (byte)(longBits >>> 56 & 0xFFL);
        buffer[offset + 1] = (byte)(longBits >>> 48 & 0xFFL);
        buffer[offset + 2] = (byte)(longBits >>> 40 & 0xFFL);
        buffer[offset + 3] = (byte)(longBits >>> 32 & 0xFFL);
        buffer[offset + 4] = (byte)(longBits >>> 24 & 0xFFL);
        buffer[offset + 5] = (byte)(longBits >>> 16 & 0xFFL);
        buffer[offset + 6] = (byte)(longBits >>> 8 & 0xFFL);
        buffer[offset + 7] = (byte)(longBits & 0xFFL);
    }
}

