/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectOutput;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.types.CharStreamHeaderGenerator;
import org.apache.derby.iapi.types.StreamHeaderGenerator;
import org.apache.derby.iapi.types.StringDataValue;

public final class ClobStreamHeaderGenerator
implements StreamHeaderGenerator {
    private static final byte MAGIC_BYTE = -16;
    private static final byte[] UNKNOWN_LENGTH = new byte[]{0, 0, -16, 0, 0};
    private static final CharStreamHeaderGenerator CHARHDRGEN = new CharStreamHeaderGenerator();
    private final StringDataValue callbackDVD;
    private Boolean inSoftUpgradeMode;

    public ClobStreamHeaderGenerator(StringDataValue dvd) {
        if (dvd == null) {
            throw new IllegalStateException("dvd cannot be null");
        }
        this.callbackDVD = dvd;
    }

    public ClobStreamHeaderGenerator(boolean inSoftUpgradeMode) {
        this.callbackDVD = null;
        this.inSoftUpgradeMode = inSoftUpgradeMode;
    }

    public boolean expectsCharCount() {
        if (this.callbackDVD != null && this.inSoftUpgradeMode == null) {
            this.determineMode();
        }
        return this.inSoftUpgradeMode == false;
    }

    public int generateInto(byte[] buf, int offset, long valueLength) {
        if (this.callbackDVD != null && this.inSoftUpgradeMode == null) {
            this.determineMode();
        }
        int headerLength = 0;
        if (this.inSoftUpgradeMode == Boolean.FALSE) {
            if (valueLength >= 0L) {
                buf[offset + headerLength++] = (byte)(valueLength >>> 24);
                buf[offset + headerLength++] = (byte)(valueLength >>> 16);
                buf[offset + headerLength++] = -16;
                buf[offset + headerLength++] = (byte)(valueLength >>> 8);
                buf[offset + headerLength++] = (byte)(valueLength >>> 0);
            } else {
                headerLength = UNKNOWN_LENGTH.length;
                System.arraycopy(UNKNOWN_LENGTH, 0, buf, offset, headerLength);
            }
        } else {
            headerLength = CHARHDRGEN.generateInto(buf, offset, valueLength);
        }
        return headerLength;
    }

    public int generateInto(ObjectOutput out, long valueLength) throws IOException {
        if (this.callbackDVD != null && this.inSoftUpgradeMode == null) {
            this.determineMode();
        }
        int headerLength = 0;
        if (this.inSoftUpgradeMode == Boolean.FALSE) {
            headerLength = 5;
            if (valueLength > 0L) {
                out.writeByte((byte)(valueLength >>> 24));
                out.writeByte((byte)(valueLength >>> 16));
                out.writeByte(-16);
                out.writeByte((byte)(valueLength >>> 8));
                out.writeByte((byte)(valueLength >>> 0));
            } else {
                out.write(UNKNOWN_LENGTH);
            }
        } else {
            headerLength = CHARHDRGEN.generateInto(out, valueLength);
        }
        return headerLength;
    }

    public int writeEOF(byte[] buffer, int offset, long valueLength) {
        if (this.callbackDVD != null && this.inSoftUpgradeMode == null) {
            this.determineMode();
        }
        if (!this.inSoftUpgradeMode.booleanValue()) {
            if (valueLength < 0L) {
                System.arraycopy(DERBY_EOF_MARKER, 0, buffer, offset, DERBY_EOF_MARKER.length);
                return DERBY_EOF_MARKER.length;
            }
            return 0;
        }
        return CHARHDRGEN.writeEOF(buffer, offset, valueLength);
    }

    public int writeEOF(ObjectOutput out, long valueLength) throws IOException {
        if (this.callbackDVD != null && this.inSoftUpgradeMode == null) {
            this.determineMode();
        }
        if (!this.inSoftUpgradeMode.booleanValue()) {
            if (valueLength < 0L) {
                out.write(DERBY_EOF_MARKER);
                return DERBY_EOF_MARKER.length;
            }
            return 0;
        }
        return CHARHDRGEN.writeEOF(out, valueLength);
    }

    private void determineMode() {
        DatabaseContext dbCtx = (DatabaseContext)ContextService.getContext("Database");
        if (dbCtx == null) {
            throw new IllegalStateException("No context, unable to determine which stream header format to generate");
        }
        DataDictionary dd = dbCtx.getDatabase().getDataDictionary();
        try {
            this.inSoftUpgradeMode = !dd.checkVersion(170, null);
        }
        catch (StandardException se) {
            IllegalStateException ise = new IllegalStateException(se.getMessage());
            ise.initCause(se);
            throw ise;
        }
        this.callbackDVD.setSoftUpgradeMode(this.inSoftUpgradeMode);
    }
}

