/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.authentication.AuthenticationServiceBase;

public final class BasicAuthenticationServiceImpl
extends AuthenticationServiceBase
implements UserAuthenticator {
    public boolean canSupport(Properties properties) {
        if (!this.requireAuthentication(properties)) {
            return false;
        }
        String authenticationProvider = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        return authenticationProvider == null || authenticationProvider.length() == 0 || StringUtil.SQLEqualsIgnoreCase(authenticationProvider, "BUILTIN");
    }

    public void boot(boolean create, Properties properties) throws StandardException {
        super.boot(create, properties);
        try {
            MessageDigest digestAlgorithm = MessageDigest.getInstance("SHA-1");
            digestAlgorithm.reset();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw Monitor.exceptionStartingModule(nsae);
        }
        this.setAuthenticationService(this);
    }

    public boolean authenticateUser(String userName, String userPassword, String databaseName, Properties info) {
        String userNameProperty;
        String clientSecurityMechanism = null;
        int secMec = 0;
        if (userName == null) {
            return false;
        }
        String definedUserPassword = null;
        String passedUserPassword = null;
        clientSecurityMechanism = info.getProperty("drdaSecMec");
        if (clientSecurityMechanism != null) {
            secMec = Integer.parseInt(clientSecurityMechanism);
        }
        if ((definedUserPassword = this.getDatabaseProperty(userNameProperty = "derby.user.".concat(userName))) != null) {
            if (secMec != 8) {
                passedUserPassword = this.encryptPassword(userPassword);
            } else {
                definedUserPassword = this.substitutePassword(userName, definedUserPassword, info, true);
                passedUserPassword = userPassword;
            }
        } else {
            definedUserPassword = this.getSystemProperty(userNameProperty);
            passedUserPassword = userPassword;
            if (definedUserPassword != null && secMec == 8) {
                definedUserPassword = this.substitutePassword(userName, definedUserPassword, info, false);
            }
        }
        if (definedUserPassword == null) {
            return false;
        }
        return definedUserPassword.equals(passedUserPassword);
    }
}

